/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.BasicDataStreamChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.entity.DigestingEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDigestingEntityProducer {
    TestDigestingEntityProducer() {
    }

    @Test
    void testProduceData() throws Exception {
        DigestingEntityProducer producer = new DigestingEntityProducer("MD5", (AsyncEntityProducer)new StringAsyncEntityProducer((CharSequence)"12345", ContentType.TEXT_PLAIN));
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel dataStreamChannel = new BasicDataStreamChannel(byteChannel);
        while (byteChannel.isOpen()) {
            producer.produce((DataStreamChannel)dataStreamChannel);
        }
        Assertions.assertEquals((Object)"12345", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
        List<Header> trailers = dataStreamChannel.getTrailers();
        Assertions.assertNotNull(trailers);
        Assertions.assertEquals((int)2, (int)trailers.size());
        Assertions.assertEquals((Object)"digest-algo", (Object)trailers.get(0).getName());
        Assertions.assertEquals((Object)"MD5", (Object)trailers.get(0).getValue());
        Assertions.assertEquals((Object)"digest", (Object)trailers.get(1).getName());
        Assertions.assertEquals((Object)"827ccb0eea8a706c4c34a16891f84e7b", (Object)trailers.get(1).getValue());
    }
}

