/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncFilterChain;
import org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AbstractAsyncServerAuthFilter;
import org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import org.apache.hc.core5.http.nio.support.BasicRequestConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.util.TimeValue;

public class AsyncServerFilterExample {
    public static void main(String[] args) throws Exception {
        int port = 8080;
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        HttpAsyncServer server = AsyncServerBootstrap.bootstrap().setExceptionCallback(e -> e.printStackTrace()).setIOReactorConfig(config).replaceFilter(StandardFilter.EXPECT_CONTINUE.name(), (AsyncFilterHandler)new AbstractAsyncServerAuthFilter<String>(true){

            protected String parseChallengeResponse(String authorizationValue, HttpContext context) throws HttpException {
                return authorizationValue;
            }

            protected boolean authenticate(String challengeResponse, URIAuthority authority, String requestUri, HttpContext context) {
                return "let me pass".equals(challengeResponse);
            }

            protected String generateChallenge(String challengeResponse, URIAuthority authority, String requestUri, HttpContext context) {
                return "who goes there?";
            }
        }).addFilterFirst("my-filter", (request, entityDetails, context, responseTrigger, chain) -> {
            if (request.getRequestUri().equals("/back-door")) {
                responseTrigger.submitResponse((HttpResponse)new BasicHttpResponse(200), AsyncEntityProducers.create((String)"Welcome"));
                return null;
            }
            return chain.proceed(request, entityDetails, context, new AsyncFilterChain.ResponseTrigger(){

                public void sendInformation(HttpResponse response) throws HttpException, IOException {
                    responseTrigger.sendInformation(response);
                }

                public void submitResponse(HttpResponse response, AsyncEntityProducer entityProducer) throws HttpException, IOException {
                    response.addHeader("X-Filter", (Object)"My-Filter");
                    responseTrigger.submitResponse(response, entityProducer);
                }

                public void pushPromise(HttpRequest promise, AsyncPushProducer responseProducer) throws HttpException, IOException {
                    responseTrigger.pushPromise(promise, responseProducer);
                }
            });
        }).register("*", (AsyncServerRequestHandler)new AsyncServerRequestHandler<Message<HttpRequest, String>>(){

            public AsyncRequestConsumer<Message<HttpRequest, String>> prepare(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException {
                return new BasicRequestConsumer((AsyncEntityConsumer)(entityDetails != null ? new StringAsyncEntityConsumer() : null));
            }

            public void handle(Message<HttpRequest, String> requestMessage, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
                responseTrigger.submitResponse(AsyncResponseBuilder.create((int)200).setEntity("Hello").build(), context);
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("HTTP server shutting down");
            server.close(CloseMode.GRACEFUL);
        }));
        server.start();
        Future future = server.listen((SocketAddress)new InetSocketAddress(port), URIScheme.HTTP);
        ListenerEndpoint listenerEndpoint = (ListenerEndpoint)future.get();
        System.out.print("Listening on " + listenerEndpoint.getAddress());
        server.awaitShutdown(TimeValue.MAX_VALUE);
    }
}

