/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.markup.MarkupTemplateEngine;
import jakarta.servlet.Servlet;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogMessage;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfig;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;

@AutoConfiguration(after={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={MarkupTemplateEngine.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GroovyTemplateAutoConfiguration.class);

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnBooleanProperty(name={"spring.groovy.template.enabled"}, matchIfMissing=true)
    public static class GroovyWebConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"groovyMarkupViewResolver"})
        public GroovyMarkupViewResolver groovyMarkupViewResolver(GroovyTemplateProperties properties) {
            GroovyMarkupViewResolver resolver = new GroovyMarkupViewResolver();
            properties.applyToMvcViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={GroovyMarkupConfigurer.class})
    public static class GroovyMarkupConfiguration {
        private final ApplicationContext applicationContext;
        private final GroovyTemplateProperties properties;

        public GroovyMarkupConfiguration(ApplicationContext applicationContext, GroovyTemplateProperties properties) {
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.checkTemplateLocationExists();
        }

        public void checkTemplateLocationExists() {
            TemplateLocation location;
            if (this.properties.isCheckTemplateLocation() && !this.isUsingGroovyAllJar() && !(location = new TemplateLocation(this.properties.getResourceLoaderPath())).exists(this.applicationContext)) {
                logger.warn(LogMessage.format("Cannot find template location: %s (please add some templates, check your Groovy configuration, or set spring.groovy.template.check-template-location=false)", (Object)location));
            }
        }

        private boolean isUsingGroovyAllJar() {
            try {
                ProtectionDomain domain2 = MarkupTemplateEngine.class.getProtectionDomain();
                CodeSource codeSource = domain2.getCodeSource();
                return codeSource != null && codeSource.getLocation().toString().contains("-all");
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={GroovyMarkupConfig.class})
        GroovyMarkupConfigurer groovyMarkupConfigurer(ObjectProvider<MarkupTemplateEngine> templateEngine, Environment environment2) {
            GroovyMarkupConfigurer configurer = new GroovyMarkupConfigurer();
            PropertyMapper map = PropertyMapper.get();
            map.from(this.properties::isAutoEscape).to(configurer::setAutoEscape);
            map.from(this.properties::isAutoIndent).to(configurer::setAutoIndent);
            map.from(this.properties::getAutoIndentString).to(configurer::setAutoIndentString);
            map.from(this.properties::isAutoNewLine).to(configurer::setAutoNewLine);
            map.from(this.properties::getBaseTemplateClass).to(configurer::setBaseTemplateClass);
            map.from(this.properties::isCache).to(configurer::setCacheTemplates);
            map.from(this.properties::getDeclarationEncoding).to(configurer::setDeclarationEncoding);
            map.from(this.properties::isExpandEmptyElements).to(configurer::setExpandEmptyElements);
            map.from(this.properties::getLocale).to(configurer::setLocale);
            map.from(this.properties::getNewLineString).to(configurer::setNewLineString);
            map.from(this.properties::getResourceLoaderPath).to(configurer::setResourceLoaderPath);
            map.from(this.properties::isUseDoubleQuotes).to(configurer::setUseDoubleQuotes);
            Binder.get(environment2).bind("spring.groovy.template.configuration", Bindable.ofInstance(configurer));
            templateEngine.ifAvailable(configurer::setTemplateEngine);
            return configurer;
        }
    }
}

