/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import jakarta.persistence.FlushModeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.AbstractAttributeStoringSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationExecution;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckingSupport;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.engine.NonPersistentTypeException;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

public abstract class AbstractSession<N>
extends AbstractAttributeStoringSession
implements SessionImplementor {
    public static final String ENTITY_ACCESS = "org.grails.gorm.ENTITY_ACCESS";
    private static final RemovalListener<PersistentEntity, Collection<PendingInsert>> EXCEPTION_THROWING_INSERT_LISTENER = (key, value, cause) -> {
        if (cause.wasEvicted()) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of insert operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    private static final RemovalListener<PersistentEntity, Collection<PendingUpdate>> EXCEPTION_THROWING_UPDATE_LISTENER = (key, value, cause) -> {
        if (cause.wasEvicted()) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of update operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    private static final RemovalListener<PersistentEntity, Collection<PendingDelete>> EXCEPTION_THROWING_DELETE_LISTENER = (key, value, cause) -> {
        if (cause.wasEvicted()) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of delete operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    private static final String NULL = "null";
    protected Map<Class, Persister> persisters = new ConcurrentHashMap<Class, Persister>();
    protected boolean isSynchronizedWithTransaction = false;
    private MappingContext mappingContext;
    protected ConcurrentLinkedQueue lockedObjects = new ConcurrentLinkedQueue();
    protected Transaction transaction;
    private Datastore datastore;
    private FlushModeType flushMode = FlushModeType.AUTO;
    protected Map<Class, Map<Serializable, Object>> firstLevelCache = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<Class, Map<Serializable, Object>> firstLevelEntryCache = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<Class, Map<Serializable, Object>> firstLevelEntryCacheDirtyCheck = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<CollectionKey, Collection> firstLevelCollectionCache = new ConcurrentHashMap<CollectionKey, Collection>();
    protected TPCacheAdapterRepository cacheAdapterRepository;
    private Collection<Serializable> objectsPendingOperations = new ConcurrentLinkedQueue<Serializable>();
    private Map<PersistentEntity, Collection<PendingInsert>> pendingInserts = Caffeine.newBuilder().removalListener(EXCEPTION_THROWING_INSERT_LISTENER).executor(Runnable::run).maximumSize(5000L).build().asMap();
    private Map<PersistentEntity, Collection<PendingUpdate>> pendingUpdates = Caffeine.newBuilder().removalListener(EXCEPTION_THROWING_UPDATE_LISTENER).executor(Runnable::run).maximumSize(5000L).build().asMap();
    private Map<PersistentEntity, Collection<PendingDelete>> pendingDeletes = Caffeine.newBuilder().removalListener(EXCEPTION_THROWING_DELETE_LISTENER).executor(Runnable::run).maximumSize(5000L).build().asMap();
    protected Collection<Runnable> postFlushOperations = new ConcurrentLinkedQueue<Runnable>();
    private boolean exceptionOccurred;
    protected ApplicationEventPublisher publisher;
    protected boolean stateless = false;
    protected boolean flushActive = false;

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        this(datastore, mappingContext, publisher, false);
    }

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless) {
        this.mappingContext = mappingContext;
        this.datastore = datastore;
        this.publisher = publisher;
        this.stateless = stateless;
    }

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, TPCacheAdapterRepository cacheAdapterRepository) {
        this(datastore, mappingContext, publisher, false);
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, TPCacheAdapterRepository cacheAdapterRepository, boolean stateless) {
        this(datastore, mappingContext, publisher, stateless);
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    @Override
    public boolean isSchemaless() {
        return this.datastore.isSchemaless();
    }

    @Override
    public boolean isStateless() {
        return this.stateless;
    }

    @Override
    public void addPostFlushOperation(Runnable runnable) {
        if (runnable != null && !this.postFlushOperations.contains(runnable)) {
            this.postFlushOperations.add(runnable);
        }
    }

    @Override
    public void addPendingInsert(PendingInsert insert) {
        Collection<PendingInsert> inserts;
        Object o = insert.getObject();
        if (o != null) {
            this.registerPending(o);
        }
        if ((inserts = this.pendingInserts.get(insert.getEntity())) == null) {
            inserts = new ConcurrentLinkedQueue<PendingInsert>();
            this.pendingInserts.put(insert.getEntity(), inserts);
        }
        inserts.add(insert);
    }

    public boolean isPendingAlready(Object obj) {
        Serializable id = this.getPersister(obj).getObjectIdentifier(obj);
        if (id != null) {
            return this.objectsPendingOperations.contains(id);
        }
        return this.objectsPendingOperations.contains(System.identityHashCode(obj));
    }

    public void registerPending(Object obj) {
        if (obj != null) {
            Serializable id = this.getPersister(obj).getObjectIdentifier(obj);
            if (id != null) {
                if (!this.objectsPendingOperations.contains(id)) {
                    this.objectsPendingOperations.add(id);
                }
            } else {
                int identityHashCode = System.identityHashCode(obj);
                if (!this.objectsPendingOperations.contains(identityHashCode)) {
                    this.objectsPendingOperations.add(Integer.valueOf(identityHashCode));
                }
            }
        }
    }

    @Override
    public void addPendingUpdate(PendingUpdate update) {
        Collection<PendingUpdate> inserts;
        Object o = update.getObject();
        if (o != null) {
            this.registerPending(o);
        }
        if ((inserts = this.pendingUpdates.get(update.getEntity())) == null) {
            inserts = new ConcurrentLinkedQueue<PendingUpdate>();
            this.pendingUpdates.put(update.getEntity(), inserts);
        }
        inserts.add(update);
    }

    public void addPendingDelete(PendingDelete delete) {
        Collection<PendingDelete> deletes;
        Object o = delete.getObject();
        if (o != null) {
            this.registerPending(o);
        }
        if ((deletes = this.pendingDeletes.get(delete.getEntity())) == null) {
            deletes = new ConcurrentLinkedQueue<PendingDelete>();
            this.pendingDeletes.put(delete.getEntity(), deletes);
        }
        deletes.add(delete);
    }

    public Object getCachedEntry(PersistentEntity entity, Serializable key) {
        if (this.isStateless(entity)) {
            return null;
        }
        return this.getCachedEntry(entity, key, false);
    }

    public Object getCachedEntry(PersistentEntity entity, Serializable key, boolean forDirtyCheck) {
        if (this.isStateless(entity)) {
            return null;
        }
        if (key == null) {
            return null;
        }
        return this.getEntryCache(entity.getJavaClass(), forDirtyCheck).get(key);
    }

    public void cacheEntry(PersistentEntity entity, Serializable key, Object entry) {
        if (this.isStateless(entity)) {
            return;
        }
        if (key == null || entry == null) {
            return;
        }
        this.cacheEntry(key, entry, this.getEntryCache(entity.getJavaClass(), true), true);
        this.cacheEntry(key, entry, this.getEntryCache(entity.getJavaClass(), false), false);
    }

    @Override
    public boolean isStateless(PersistentEntity entity) {
        Entity mappedForm = entity != null ? (Entity)entity.getMapping().getMappedForm() : null;
        return this.isStateless() || mappedForm != null && mappedForm.isStateless();
    }

    protected void cacheEntry(Serializable key, Object entry, Map<Serializable, Object> entryCache, boolean forDirtyCheck) {
        if (this.isStateless()) {
            return;
        }
        entryCache.put(key, entry);
    }

    @Override
    public Collection getCachedCollection(PersistentEntity entity, Serializable key, String name) {
        if (this.isStateless(entity)) {
            return null;
        }
        if (key == null || name == null) {
            return null;
        }
        return this.firstLevelCollectionCache.get(new CollectionKey(entity.getJavaClass(), key, name));
    }

    @Override
    public void cacheCollection(PersistentEntity entity, Serializable key, Collection collection, String name) {
        if (this.isStateless(entity)) {
            return;
        }
        if (key == null || collection == null || name == null) {
            return;
        }
        this.firstLevelCollectionCache.put(new CollectionKey(entity.getJavaClass(), key, name), collection);
    }

    @Override
    public Map<PersistentEntity, Collection<PendingInsert>> getPendingInserts() {
        return this.pendingInserts;
    }

    @Override
    public Map<PersistentEntity, Collection<PendingUpdate>> getPendingUpdates() {
        return this.pendingUpdates;
    }

    @Override
    public Map<PersistentEntity, Collection<PendingDelete>> getPendingDeletes() {
        return this.pendingDeletes;
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public Datastore getDatastore() {
        return this.datastore;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public void flush() {
        boolean hasInserts;
        if (this.flushActive) {
            return;
        }
        try {
            if (this.exceptionOccurred) {
                throw new InvalidDataAccessResourceUsageException("Do not flush() the Session after an exception occurs");
            }
            this.flushActive = true;
            hasInserts = this.hasUpdates();
            if (hasInserts) {
                this.flushPendingInserts(this.pendingInserts);
                this.flushPendingUpdates(this.pendingUpdates);
                this.flushPendingDeletes(this.pendingDeletes);
                this.firstLevelCollectionCache.clear();
                this.executePendings(this.postFlushOperations);
            }
        }
        finally {
            this.clearPendingOperations();
            this.flushActive = false;
        }
        this.postFlush(hasInserts);
    }

    protected void flushPendingDeletes(Map<PersistentEntity, Collection<PendingDelete>> pendingDeletes) {
        Collection<Collection<PendingDelete>> deletes = pendingDeletes.values();
        for (Collection<PendingDelete> delete : deletes) {
            this.flushPendingOperations(delete);
        }
    }

    @Override
    public boolean isDirty(Object instance) {
        if (instance == null) {
            return false;
        }
        EntityPersister persister = (EntityPersister)this.getPersister(instance);
        if (persister == null) {
            return false;
        }
        if (instance instanceof DirtyCheckable) {
            return ((DirtyCheckable)instance).hasChanged() || DirtyCheckingSupport.areAssociationsDirty(this, persister.getPersistentEntity(), instance);
        }
        if (!(persister instanceof NativeEntryEntityPersister)) {
            return false;
        }
        Serializable id = persister.getObjectIdentifier(instance);
        if (id == null) {
            return false;
        }
        Object entry = this.getCachedEntry(persister.getPersistentEntity(), id, false);
        Object instance2 = this.getCachedInstance(instance.getClass(), id);
        return instance != instance2 || ((NativeEntryEntityPersister)persister).isDirty(instance, entry);
    }

    @Override
    public Serializable getObjectIdentifier(Object instance) {
        Persister persister = this.getPersister(instance);
        if (persister != null) {
            return persister.getObjectIdentifier(instance);
        }
        return null;
    }

    protected void flushPendingUpdates(Map<PersistentEntity, Collection<PendingUpdate>> updates) {
        for (Collection<PendingUpdate> pending : updates.values()) {
            this.flushPendingOperations(pending);
        }
    }

    protected void flushPendingInserts(Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        for (Collection<PendingInsert> pending : inserts.values()) {
            this.flushPendingOperations(pending);
        }
    }

    private void flushPendingOperations(Collection operations) {
        for (Object o : operations) {
            PendingOperation pendingOperation = (PendingOperation)o;
            try {
                PendingOperationExecution.executePendingOperation(pendingOperation);
            }
            catch (RuntimeException e) {
                this.setFlushMode(FlushModeType.COMMIT);
                this.exceptionOccurred = true;
                throw e;
            }
        }
    }

    private boolean hasUpdates() {
        return !this.pendingInserts.isEmpty() || !this.pendingUpdates.isEmpty() || !this.pendingDeletes.isEmpty() || !this.postFlushOperations.isEmpty();
    }

    protected void postFlush(boolean hasUpdates) {
    }

    protected void executePendings(Collection<? extends Runnable> pendings) {
        try {
            for (Runnable runnable : pendings) {
                runnable.run();
            }
        }
        catch (RuntimeException e) {
            this.setFlushMode(FlushModeType.COMMIT);
            this.exceptionOccurred = true;
            throw e;
        }
    }

    @Override
    public void clear() {
        this.clearMaps(this.firstLevelCache);
        this.clearMaps(this.firstLevelEntryCache);
        this.clearMaps(this.firstLevelEntryCacheDirtyCheck);
        this.firstLevelCollectionCache.clear();
        this.clearPendingOperations();
        this.attributes.clear();
        this.exceptionOccurred = false;
    }

    protected void clearPendingOperations() {
        this.objectsPendingOperations.clear();
        this.pendingInserts.clear();
        this.pendingUpdates.clear();
        this.pendingDeletes.clear();
        this.postFlushOperations.clear();
    }

    private void clearMaps(Map<Class, Map<Serializable, Object>> mapOfMaps) {
        for (Map<Serializable, Object> cache : mapOfMaps.values()) {
            cache.clear();
        }
    }

    @Override
    public final Persister getPersister(Object o) {
        if (o == null) {
            return null;
        }
        Class cls = o instanceof Class ? (Class)o : (o instanceof PersistentEntity ? ((PersistentEntity)o).getJavaClass() : o.getClass());
        Persister p = this.persisters.get(cls);
        if (p == null && (p = this.createPersister(cls, this.getMappingContext())) != null) {
            if (!this.isStateless(((EntityPersister)p).getPersistentEntity())) {
                this.firstLevelCache.put(cls, new ConcurrentHashMap());
            }
            this.persisters.put(cls, p);
        }
        return p;
    }

    protected abstract Persister createPersister(Class var1, MappingContext var2);

    @Override
    public boolean contains(Object o) {
        if (o == null || this.isStateless()) {
            return false;
        }
        Serializable identifier = this.getObjectIdentifier(o);
        if (identifier != null) {
            return this.getInstanceCache(o.getClass()).containsKey(identifier);
        }
        return this.getInstanceCache(o.getClass()).containsValue(o);
    }

    @Override
    public boolean isCached(Class type, Serializable key) {
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(type.getName());
        if (type == null || key == null || this.isStateless(entity)) {
            return false;
        }
        return this.getInstanceCache(type).containsKey(key);
    }

    @Override
    public void cacheInstance(Class type, Serializable key, Object instance) {
        if (type == null || key == null || instance == null) {
            return;
        }
        if (this.isStateless(this.getMappingContext().getPersistentEntity(type.getName()))) {
            return;
        }
        this.getInstanceCache(type).put(key, instance);
    }

    @Override
    public Object getCachedInstance(Class type, Serializable key) {
        if (this.isStateless()) {
            return null;
        }
        if (type == null || key == null) {
            return null;
        }
        if (this.isStateless(this.getMappingContext().getPersistentEntity(type.getName()))) {
            return null;
        }
        return this.getInstanceCache(type).get(key);
    }

    @Override
    public void clear(Object o) {
        Persister persister;
        Serializable key;
        if (o == null || this.isStateless()) {
            return;
        }
        Map<Serializable, Object> cache = this.firstLevelCache.get(o.getClass());
        if (cache != null && (key = (persister = this.getPersister(o)).getObjectIdentifier(o)) != null) {
            cache.remove(key);
        }
        this.removeAttributesForEntity(o);
    }

    @Override
    public void attach(Object o) {
        if (o == null) {
            return;
        }
        EntityPersister p = (EntityPersister)this.getPersister(o);
        if (p == null) {
            return;
        }
        Serializable identifier = p.getObjectIdentifier(o);
        if (identifier != null) {
            this.cacheObject(identifier, o);
        }
    }

    protected void cacheObject(Serializable identifier, Object o) {
        if (identifier == null || o == null) {
            return;
        }
        this.cacheInstance(o.getClass(), identifier, o);
    }

    @Override
    public Serializable persist(Object o) {
        Assert.notNull(o, "Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + String.valueOf(o) + "] cannot be persisted. It is not a known persistent type.");
        }
        Serializable key = persister.persist(o);
        this.cacheObject(key, o);
        return key;
    }

    @Override
    public Serializable insert(Object o) {
        Assert.notNull(o, "Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + String.valueOf(o) + "] cannot be persisted. It is not a known persistent type.");
        }
        Serializable key = persister.insert(o);
        this.cacheObject(key, o);
        return key;
    }

    @Override
    public void refresh(Object o) {
        Assert.notNull(o, "Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + String.valueOf(o) + "] cannot be refreshed. It is not a known persistent type.");
        }
        Serializable key = persister.refresh(o);
        this.cacheObject(key, o);
    }

    public Object retrieve(Class type, Serializable key) {
        PersistentProperty identity;
        if (key == null || type == null || NULL.equals(key)) {
            return null;
        }
        Persister persister = this.getPersister(type);
        if (persister == null) {
            throw new NonPersistentTypeException("Cannot retrieve object with key [" + String.valueOf(key) + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        PersistentEntity entity = ((EntityPersister)persister).getPersistentEntity();
        if (entity != null && !(identity = entity.getIdentity()).getType().isAssignableFrom(key.getClass())) {
            key = this.convertIdentityIfNecessasry(identity, key);
        }
        if (key == null) {
            return null;
        }
        Object o = this.getInstanceCache(type).get(key);
        if (o == null && (o = persister.retrieve(key)) != null) {
            this.cacheObject(key, o);
        }
        return o;
    }

    protected Serializable convertIdentityIfNecessasry(PersistentProperty identity, Serializable key) {
        ConversionService conversionService = this.getMappingContext().getConversionService();
        if (conversionService.canConvert(key.getClass(), identity.getType())) {
            try {
                key = (Serializable)conversionService.convert((Object)key, identity.getType());
            }
            catch (ConversionFailedException conversionFailedException) {
                // empty catch block
            }
        }
        return key;
    }

    public Object proxy(Class type, Serializable key) {
        if (key == null || type == null) {
            return null;
        }
        Persister persister = this.getPersister(type);
        if (persister == null) {
            throw new NonPersistentTypeException("Cannot retrieve object with key [" + String.valueOf(key) + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        Object o = this.getInstanceCache(type).get(key);
        if (o == null) {
            o = persister.proxy(key);
        }
        return o;
    }

    @Override
    public void lock(Object o) {
        throw new UnsupportedOperationException("Datastore [" + this.getClass().getName() + "] does not support locking.");
    }

    public Object lock(Class type, Serializable key) {
        throw new UnsupportedOperationException("Datastore [" + this.getClass().getName() + "] does not support locking.");
    }

    @Override
    public void unlock(Object o) {
        if (o != null) {
            this.lockedObjects.remove(o);
        }
    }

    @Override
    public long deleteAll(QueryableCriteria criteria) {
        List list = criteria.list();
        this.delete(list);
        return list.size();
    }

    @Override
    public long updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        List list = criteria.list();
        for (Object o : list) {
            BeanWrapperImpl bean2 = new BeanWrapperImpl(o);
            for (String property : properties.keySet()) {
                bean2.setPropertyValue(property, properties.get(property));
            }
        }
        this.persist(list);
        return list.size();
    }

    @Override
    public void delete(Object obj) {
        if (obj == null) {
            return;
        }
        EntityPersister p = (EntityPersister)this.getPersister(obj);
        if (p == null) {
            return;
        }
        p.delete(obj);
        this.clear(obj);
    }

    @Override
    public void delete(Iterable objects) {
        Persister p;
        if (objects == null) {
            return;
        }
        HashMap toDelete = new HashMap();
        for (Object t : objects) {
            if (t == null || (p = this.getPersister(t)) == null) continue;
            ArrayList listForPersister = (ArrayList)toDelete.get(p);
            if (listForPersister == null) {
                listForPersister = new ArrayList();
                toDelete.put(p, listForPersister);
            }
            listForPersister.add(t);
        }
        for (Map.Entry entry : toDelete.entrySet()) {
            p = (EntityPersister)entry.getKey();
            ((EntityPersister)p).delete((Iterable)entry.getValue());
        }
    }

    @Override
    public List<Serializable> persist(Iterable objects) {
        if (objects == null) {
            return Collections.emptyList();
        }
        Iterator i2 = objects.iterator();
        if (!i2.hasNext()) {
            return Collections.emptyList();
        }
        Object obj = i2.next();
        Persister p = this.getPersister(obj);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot persist objects. The class [" + obj.getClass().getName() + "] is not a known persistent type.");
        }
        return p.persist(objects);
    }

    @Override
    public List retrieveAll(Class type, Iterable keys) {
        EntityPersister p = (EntityPersister)this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot retrieve objects with keys [" + String.valueOf(keys) + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        ArrayList<Iterator<Object>> list = new ArrayList<Iterator<Object>>();
        ArrayList<Serializable> toRetrieve = new ArrayList<Serializable>();
        Map<Serializable, Object> cache = this.getInstanceCache(type);
        for (Object key : keys) {
            Serializable serializable = (Serializable)key;
            Iterator<Object> cached = cache.get(serializable);
            list.add(cached);
            if (cached != null) continue;
            toRetrieve.add(serializable);
        }
        List<Object> retrieved = p.retrieveAll(toRetrieve);
        Iterator keyIterator = toRetrieve.iterator();
        HashMap<Serializable, Object> retrievedMap = new HashMap<Serializable, Object>();
        for (Object o : retrieved) {
            Serializable identifier = p.getObjectIdentifier(o);
            if (identifier == null) continue;
            retrievedMap.put(identifier, o);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object o;
            o = list.get(i2);
            if (o != null || !keyIterator.hasNext()) continue;
            Serializable key = (Serializable)keyIterator.next();
            key = (Serializable)this.mappingContext.getConversionService().convert((Object)key, p.getPersistentEntity().getIdentity().getType());
            Object next = retrievedMap.get(key);
            list.set(i2, (Iterator<Object>)next);
            this.cacheInstance(type, key, next);
        }
        return list;
    }

    @Override
    public List retrieveAll(Class type, Serializable ... keys) {
        Persister p = this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot retrieve objects with keys [" + String.valueOf(keys) + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        return this.retrieveAll(type, Arrays.asList(keys));
    }

    @Override
    public Query createQuery(Class type) {
        Persister p = this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot create query. The class [" + String.valueOf(type) + "] is not a known persistent type.");
        }
        return p.createQuery();
    }

    @Override
    public final Transaction beginTransaction() {
        return this.beginTransaction(new DefaultTransactionDefinition());
    }

    @Override
    public Transaction beginTransaction(TransactionDefinition definition) {
        this.transaction = this.beginTransactionInternal();
        return this.transaction;
    }

    protected abstract Transaction beginTransactionInternal();

    @Override
    public Transaction getTransaction() {
        if (this.transaction == null) {
            throw new NoTransactionException("Transaction not started. Call beginTransaction() first");
        }
        return this.transaction;
    }

    @Override
    public boolean hasTransaction() {
        return this.transaction != null;
    }

    private Map<Serializable, Object> getInstanceCache(Class c) {
        Map<Serializable, Object> cache = this.firstLevelCache.get(c);
        if (cache == null) {
            cache = new ConcurrentHashMap<Serializable, Object>();
            this.firstLevelCache.put(c, cache);
        }
        return cache;
    }

    private Map<Serializable, Object> getEntryCache(Class c, boolean forDirtyCheck) {
        Map<Class, Map<Serializable, Object>> caches = forDirtyCheck ? this.firstLevelEntryCacheDirtyCheck : this.firstLevelEntryCache;
        Map<Serializable, Object> cache = caches.get(c);
        if (cache == null) {
            cache = new ConcurrentHashMap<Serializable, Object>();
            caches.put(c, cache);
        }
        return cache;
    }

    @Override
    public EntityAccess createEntityAccess(PersistentEntity entity, Object instance) {
        return this.getMappingContext().createEntityAccess(entity, instance);
    }

    @Override
    public void setSynchronizedWithTransaction(boolean isSynchronizedWithTransaction) {
        this.isSynchronizedWithTransaction = isSynchronizedWithTransaction;
    }

    private static class CollectionKey {
        final Class clazz;
        final Serializable key;
        final String collectionName;

        private CollectionKey(Class clazz, Serializable key, String collectionName) {
            this.clazz = clazz;
            this.key = key;
            this.collectionName = collectionName;
        }

        public int hashCode() {
            int value = 17;
            value = value * 37 + this.clazz.getName().hashCode();
            value = value * 37 + this.key.hashCode();
            value = value * 37 + this.collectionName.hashCode();
            return value;
        }

        public boolean equals(Object obj) {
            CollectionKey other = (CollectionKey)obj;
            return other.clazz.getName() == this.clazz.getName() && other.key.equals(this.key) && other.collectionName.equals(this.collectionName);
        }

        public String toString() {
            return this.clazz.getName() + ":" + String.valueOf(this.key) + ":" + this.collectionName;
        }
    }
}

