/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.IMetaInfo;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.SetterNode;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;

public class ObjectDefinePropertyEmitter
extends JSSubEmitter
implements ISubEmitter<IAccessorNode> {
    public ObjectDefinePropertyEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IAccessorNode node) {
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
        IFunctionDefinition definition = node.getDefinition();
        ITypeDefinition type = (ITypeDefinition)definition.getParent();
        if (type == null) {
            return;
        }
        boolean isBindableSetter = false;
        if (node instanceof SetterNode) {
            IMetaInfo[] metaInfos = null;
            for (IMetaInfo metaInfo : metaInfos = node.getMetaInfos()) {
                String name = metaInfo.getTagName();
                if (!name.equals("Bindable") || metaInfo.getAllAttributes().length != 0) continue;
                isBindableSetter = true;
                break;
            }
        }
        if (isBindableSetter) {
            fjs.getDocEmitter().emitMethodDoc((IFunctionNode)fn, this.getWalker().getProject());
            this.write(fjs.formatQualifiedName(type.getQualifiedName()));
            if (!node.hasModifier(ASModifier.STATIC)) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write("__bindingWrappedSetter__");
            this.writeToken(node.getName());
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            fjs.emitParameters(node.getParametersContainerNode());
            fjs.emitMethodScope(node.getScopedNode());
        }
        this.super_emitObjectDefineProperty(node);
    }

    protected void super_emitObjectDefineProperty(IAccessorNode node) {
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTY);
        fjs.writeNewline(ASEmitterTokens.PAREN_OPEN, true);
        IFunctionDefinition definition = node.getDefinition();
        ITypeDefinition type = (ITypeDefinition)definition.getParent();
        this.write(type.getQualifiedName());
        if (!node.hasModifier(ASModifier.STATIC)) {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
        }
        this.writeToken(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(definition.getBaseName());
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.writeToken(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.write(node.getNodeID() == ASTNodeID.GetterID ? ASEmitterTokens.GET : ASEmitterTokens.SET);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.FUNCTION);
        fjs.emitParameters(node.getParametersContainerNode());
        fjs.emitDefinePropertyFunction(node);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(JSEmitterTokens.CONFIGURABLE);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.TRUE);
        fjs.writeNewline(ASEmitterTokens.BLOCK_CLOSE, false);
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }
}

