/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Arrays;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class MemoSequence
implements Sequence {
    private final SequenceIterator inputIterator;
    private Item[] reservoir = null;
    private int used;
    private LearningEvaluator learningEvaluator;
    private int serialNumber;
    private State state = State.UNREAD;

    public MemoSequence(SequenceIterator iterator) {
        this.inputIterator = iterator;
    }

    public void setLearningEvaluator(LearningEvaluator caller, int serialNumber) {
        this.learningEvaluator = caller;
        this.serialNumber = serialNumber;
    }

    @Override
    public Item head() throws XPathException {
        return this.iterate().next();
    }

    @Override
    public synchronized SequenceIterator iterate() {
        switch (this.state.ordinal()) {
            case 0: {
                this.state = State.BUSY;
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = State.EMPTY;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = State.MAYBE_MORE;
                return new ProgressiveIterator(this);
            }
            case 1: {
                return new ProgressiveIterator(this);
            }
            case 2: {
                switch (this.used) {
                    case 0: {
                        this.state = State.EMPTY;
                        return EmptyIterator.getInstance();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator.Of(this.reservoir, 0, this.used);
            }
            case 3: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated", "XTDE0640");
                throw new UncheckedXPathException(de);
            }
            case 4: {
                return EmptyIterator.getInstance();
            }
            case 5: {
                XPathException e2 = new XPathException("Attempting to read a local variable when an error in that variable has already been reported", "XTDE0640");
                throw new UncheckedXPathException(e2);
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public synchronized Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.used) {
            return this.reservoir[n];
        }
        if (this.state == State.ALL_READ || this.state == State.EMPTY) {
            return null;
        }
        if (this.state == State.ERROR) {
            throw new XPathException("Attempting to read a local variable when an error in that variable has already been reported", "XTDE0640");
        }
        if (this.state == State.UNREAD) {
            Item item = this.inputIterator.next();
            if (item == null) {
                this.state = State.EMPTY;
                return null;
            }
            this.state = State.MAYBE_MORE;
            this.reservoir = new Item[50];
            this.append(item);
            if (n == 0) {
                return item;
            }
        }
        int diff = n - this.used + 1;
        try {
            while (diff-- > 0) {
                Item i = this.inputIterator.next();
                if (i == null) {
                    this.state = State.ALL_READ;
                    this.condense();
                    return null;
                }
                this.append(i);
                this.state = State.MAYBE_MORE;
            }
        }
        catch (UncheckedXPathException e) {
            this.state = State.ERROR;
            throw e.getXPathException();
        }
        return this.reservoir[n];
    }

    private void append(Item item) {
        assert (this.reservoir != null);
        if (this.used >= this.reservoir.length) {
            this.reservoir = Arrays.copyOf(this.reservoir, this.used * 2);
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir != null && this.reservoir.length - this.used > 30) {
            this.reservoir = Arrays.copyOf(this.reservoir, this.used);
        }
    }

    private static enum State {
        UNREAD,
        MAYBE_MORE,
        ALL_READ,
        BUSY,
        EMPTY,
        ERROR;

    }

    public static final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        private final MemoSequence container;
        private int position = -1;

        public ProgressiveIterator(MemoSequence container) {
            this.container = container;
        }

        public MemoSequence getMemoSequence() {
            return this.container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Item next() {
            MemoSequence memoSequence = this.container;
            synchronized (memoSequence) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < this.container.used) {
                    assert (this.container.reservoir != null);
                    return this.container.reservoir[this.position];
                }
                if (this.container.state == State.ALL_READ) {
                    this.position = -2;
                    return null;
                }
                assert (this.container.inputIterator != null);
                Item i = null;
                try {
                    i = this.container.inputIterator.next();
                    if (i == null) {
                        this.container.state = State.ALL_READ;
                        this.container.condense();
                        this.position = -2;
                        this.reportCompletion();
                        return null;
                    }
                }
                catch (UncheckedXPathException e) {
                    this.container.state = State.ERROR;
                    throw e;
                }
                this.position = this.container.used;
                this.container.append(i);
                this.container.state = State.MAYBE_MORE;
                return i;
            }
        }

        @Override
        public boolean supportsGetLength() {
            return true;
        }

        @Override
        public int getLength() {
            if (this.container.state == State.ALL_READ) {
                return this.container.used;
            }
            if (this.container.state == State.EMPTY) {
                return 0;
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return this.container.used;
        }

        @Override
        public boolean isActuallyGrounded() {
            return true;
        }

        @Override
        public GroundedValue materialize() {
            if (this.container.state == State.ALL_READ) {
                return this.makeExtent();
            }
            if (this.container.state == State.EMPTY) {
                return EmptySequence.getInstance();
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return this.makeExtent();
        }

        private GroundedValue makeExtent() {
            if (this.container.used == this.container.reservoir.length) {
                if (this.container.used == 0) {
                    return EmptySequence.getInstance();
                }
                if (this.container.used == 1) {
                    return this.container.reservoir[0];
                }
                return new SequenceExtent.Of(this.container.reservoir);
            }
            return SequenceExtent.makeSequenceExtent(Arrays.asList(this.container.reservoir).subList(0, this.container.used));
        }

        @Override
        public GroundedValue getResidue() {
            if (this.container.state == State.EMPTY || this.position >= this.container.used || this.position == -2) {
                return EmptySequence.getInstance();
            }
            if (this.container.state == State.ALL_READ) {
                return SequenceExtent.makeSequenceExtent(Arrays.asList(this.container.reservoir).subList(this.position + 1, this.container.used));
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return SequenceExtent.makeSequenceExtent(Arrays.asList(this.container.reservoir).subList(this.position + 1, this.container.used));
        }

        @Override
        public void close() {
            if (this.container.state == State.ALL_READ) {
                this.reportCompletion();
            }
        }

        private void reportCompletion() {
            if (this.container.learningEvaluator != null) {
                this.container.learningEvaluator.reportCompletion(this.container.serialNumber);
            }
        }
    }
}

