/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class RealMatrixFormatAbstractTest {
    RealMatrixFormat realMatrixFormat = RealMatrixFormat.getInstance((Locale)this.getLocale());
    RealMatrixFormat realMatrixFormatOctave = null;

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    public RealMatrixFormatAbstractTest() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(2);
        this.realMatrixFormatOctave = new RealMatrixFormat("[", "]", "", "", "; ", ", ", nf);
    }

    @Test
    public void testSimpleNoDecimals() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        String expected = "{{1,1,1},{1,1,1}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.23, 1.43, 1.63}, {2.46, 2.46, 2.66}});
        String expected = "{{1" + this.getDecimalCharacter() + "23,1" + this.getDecimalCharacter() + "43,1" + this.getDecimalCharacter() + "63},{2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "66}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.232323232323, 1.43, 1.63}, {2.46, 2.46, 2.666666666666}});
        String expected = "{{1" + this.getDecimalCharacter() + "2323232323,1" + this.getDecimalCharacter() + "43,1" + this.getDecimalCharacter() + "63},{2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "6666666667}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeComponent() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{-1.232323232323, 1.43, 1.63}, {2.46, 2.46, 2.66}});
        String expected = "{{-1" + this.getDecimalCharacter() + "2323232323,1" + this.getDecimalCharacter() + "43,1" + this.getDecimalCharacter() + "63},{2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "66}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeComponent2() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.23, -1.434343434343, 1.63}, {2.46, 2.46, 2.66}});
        String expected = "{{1" + this.getDecimalCharacter() + "23,-1" + this.getDecimalCharacter() + "4343434343,1" + this.getDecimalCharacter() + "63},{2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "66}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeSecondRow() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.23, 1.43, 1.63}, {-2.66666666666, 2.46, 2.66}});
        String expected = "{{1" + this.getDecimalCharacter() + "23,1" + this.getDecimalCharacter() + "43,1" + this.getDecimalCharacter() + "63},{-2" + this.getDecimalCharacter() + "6666666667,2" + this.getDecimalCharacter() + "46,2" + this.getDecimalCharacter() + "66}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNonDefaultSetting() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        String expected = "[1, 1, 1; 1, 1, 1]";
        String actual = this.realMatrixFormatOctave.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormat() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{232.2222222222, -342.33333333333, 432.44444444444}});
        String expected = "{{232" + this.getDecimalCharacter() + "2222222222,-342" + this.getDecimalCharacter() + "3333333333,432" + this.getDecimalCharacter() + "4444444444}}";
        String actual = new RealMatrixFormat().format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testNan() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.NaN, Double.NaN, Double.NaN}});
        String expected = "{{(NaN),(NaN),(NaN)}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}});
        String expected = "{{(Infinity),(Infinity),(Infinity)}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void tesNegativeInfinity() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}});
        String expected = "{{(-Infinity),(-Infinity),(-Infinity)}}";
        String actual = this.realMatrixFormat.format(m);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() {
        String source = "{{1, 1, 1}, {1, 1, 1}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    @Ignore
    public void testParseSimpleWithClosingRowSeparator() {
        String source = "{{1, 1, 1},{1, 1, 1}, }}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseIgnoredWhitespace() {
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        ParsePosition pos1 = new ParsePosition(0);
        String source1 = "{{1,1,1},{1,1,1}}";
        Assert.assertEquals((Object)expected, (Object)this.realMatrixFormat.parse(source1, pos1));
        Assert.assertEquals((long)source1.length(), (long)pos1.getIndex());
        ParsePosition pos2 = new ParsePosition(0);
        String source2 = " { { 1 , 1 , 1 } , { 1 , 1 , 1 } } ";
        Assert.assertEquals((Object)expected, (Object)this.realMatrixFormat.parse(source2, pos2));
        Assert.assertEquals((long)(source2.length() - 1), (long)pos2.getIndex());
    }

    @Test
    public void testParseSimpleWithDecimals() {
        String source = "{{1" + this.getDecimalCharacter() + "23,1" + this.getDecimalCharacter() + "43,1" + this.getDecimalCharacter() + "63}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.23, 1.43, 1.63}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() {
        String source = "{{1" + this.getDecimalCharacter() + "2323,1" + this.getDecimalCharacter() + "4343,1" + this.getDecimalCharacter() + "6333}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.2323, 1.4343, 1.6333}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeComponent() {
        String source = "{{-1" + this.getDecimalCharacter() + "2323,1" + this.getDecimalCharacter() + "4343,1" + this.getDecimalCharacter() + "6333}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{-1.2323, 1.4343, 1.6333}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeAll() {
        String source = "{{-1" + this.getDecimalCharacter() + "2323,-1" + this.getDecimalCharacter() + "4343,-1" + this.getDecimalCharacter() + "6333}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{-1.2323, -1.4343, -1.6333}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroComponent() {
        String source = "{{0" + this.getDecimalCharacter() + "0,-1" + this.getDecimalCharacter() + "4343,1" + this.getDecimalCharacter() + "6333}}";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, -1.4343, 1.6333}});
        RealMatrix actual = this.realMatrixFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNonDefaultSetting() {
        String source = "[1" + this.getDecimalCharacter() + "2323, 1" + this.getDecimalCharacter() + "4343, 1" + this.getDecimalCharacter() + "6333]";
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.2323, 1.4343, 1.6333}});
        RealMatrix actual = this.realMatrixFormatOctave.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() {
        String source = "{{(NaN), (NaN), (NaN)}}";
        RealMatrix actual = this.realMatrixFormat.parse(source);
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.NaN, Double.NaN, Double.NaN}});
        for (int i = 0; i < expected.getRowDimension(); ++i) {
            for (int j = 0; j < expected.getColumnDimension(); ++j) {
                Assert.assertTrue((boolean)Double.isNaN(actual.getEntry(i, j)));
            }
        }
    }

    @Test
    public void testParsePositiveInfinity() {
        String source = "{{(Infinity), (Infinity), (Infinity)}}";
        RealMatrix actual = this.realMatrixFormat.parse(source);
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeInfinity() {
        String source = "{{(-Infinity), (-Infinity), (-Infinity)}}";
        RealMatrix actual = this.realMatrixFormat.parse(source);
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNoComponents() {
        try {
            this.realMatrixFormat.parse("{{ }}");
            Assert.fail((String)"Expecting MathParseException");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseManyComponents() {
        RealMatrix parsed = this.realMatrixFormat.parse("{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}");
        Assert.assertEquals((long)24L, (long)parsed.getColumnDimension());
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        RealMatrixFormat mf = new RealMatrixFormat(nf);
        Assert.assertNotNull((Object)mf);
        Assert.assertEquals((Object)nf, (Object)mf.getFormat());
    }

    @Test
    public void testForgottenPrefix() {
        ParsePosition pos = new ParsePosition(0);
        String source = "1; 1; 1]";
        Assert.assertNull((String)"Should not parse <1; 1; 1]>", (Object)this.realMatrixFormat.parse("1; 1; 1]", pos));
        Assert.assertEquals((long)0L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSeparator() {
        ParsePosition pos = new ParsePosition(0);
        String source = "{{1, 1 1}}";
        Assert.assertNull((String)"Should not parse <{{1, 1 1}}>", (Object)this.realMatrixFormat.parse("{{1, 1 1}}", pos));
        Assert.assertEquals((long)7L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSuffix() {
        ParsePosition pos = new ParsePosition(0);
        String source = "{{1, 1, 1 ";
        Assert.assertNull((String)"Should not parse <{{1, 1, 1 >", (Object)this.realMatrixFormat.parse("{{1, 1, 1 ", pos));
        Assert.assertEquals((long)9L, (long)pos.getErrorIndex());
    }
}

