/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.MockCacheEventLogger;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPDiscoveryListenerUnitTest
extends TestCase {
    private LateralTCPDiscoveryListener listener;
    private LateralTCPCacheFactory factory;
    private CompositeCacheManager cacheMgr;
    protected MockCacheEventLogger cacheEventLogger;
    protected IElementSerializer elementSerializer;

    protected void setUp() throws Exception {
        this.factory = new LateralTCPCacheFactory();
        this.factory.initialize();
        this.cacheMgr = CompositeCacheManager.getInstance();
        this.cacheEventLogger = new MockCacheEventLogger();
        this.elementSerializer = new StandardSerializer();
        this.listener = new LateralTCPDiscoveryListener(this.factory.getName(), this.cacheMgr, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
    }

    private LateralCacheNoWaitFacade<String, String> setupFacade(String cacheName) {
        ArrayList noWaits = new ArrayList();
        TCPLateralCacheAttributes cattr = new TCPLateralCacheAttributes();
        cattr.setCacheName(cacheName);
        return new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
    }

    private LateralCacheNoWait<String, String> setupNoWait(String cacheName) {
        TCPLateralCacheAttributes cattr = new TCPLateralCacheAttributes();
        cattr.setCacheName(cacheName);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr, (ICacheServiceNonLocal)new ZombieCacheServiceNonLocal(), null);
        return new LateralCacheNoWait(cache);
    }

    public void testAddNoWaitFacade_NotInList() {
        String cacheName = "testAddNoWaitFacade_NotInList";
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testAddNoWaitFacade_NotInList");
        this.listener.addNoWaitFacade("testAddNoWaitFacade_NotInList", facade);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have the facade.", (boolean)this.listener.containsNoWaitFacade("testAddNoWaitFacade_NotInList"));
    }

    public void testAddNoWait_FacadeInList() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testAddNoWaitFacade_FacadeInList");
        this.listener.addNoWaitFacade("testAddNoWaitFacade_FacadeInList", facade);
        LateralCacheNoWait<String, String> noWait = this.setupNoWait("testAddNoWaitFacade_FacadeInList");
        boolean result = this.listener.addNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have added the no wait.", (boolean)result);
    }

    public void testAddNoWait_FacadeNotInList() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheNoWait<String, String> noWait = this.setupNoWait("testAddNoWaitFacade_FacadeInList");
        boolean result = this.listener.addNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have added the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeNotInList() {
        String cacheName = "testRemoveNoWaitFacade_FacadeNotInList";
        LateralCacheNoWait<String, String> noWait = this.setupNoWait("testRemoveNoWaitFacade_FacadeNotInList");
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have removed the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeInList_NoWaitNot() {
        String cacheName = "testAddNoWaitFacade_FacadeInList";
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testAddNoWaitFacade_FacadeInList");
        this.listener.addNoWaitFacade("testAddNoWaitFacade_FacadeInList", facade);
        LateralCacheNoWait<String, String> noWait = this.setupNoWait("testAddNoWaitFacade_FacadeInList");
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have removed the no wait.", (boolean)result);
    }

    public void testRemoveNoWait_FacadeInList_NoWaitIs() {
        String cacheName = "testRemoveNoWaitFacade_FacadeInListNoWaitIs";
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testRemoveNoWaitFacade_FacadeInListNoWaitIs");
        this.listener.addNoWaitFacade("testRemoveNoWaitFacade_FacadeInListNoWaitIs", facade);
        LateralCacheNoWait<String, String> noWait = this.setupNoWait("testRemoveNoWaitFacade_FacadeInListNoWaitIs");
        this.listener.addNoWait(noWait);
        boolean result = this.listener.removeNoWait(noWait);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have removed the no wait.", (boolean)result);
    }

    public void testEmptyNoWaits() {
        String cacheName = "testEmptyNoWaits";
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTcpServers("");
        lca.setTcpListenerPort(1120);
        lca.setCacheName("testEmptyNoWaits");
        lca.setUdpDiscoveryEnabled(false);
        LateralCacheNoWaitFacade noWait = this.factory.createCache((AuxiliaryCacheAttributes)lca, (ICompositeCacheManager)this.cacheMgr, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"No waits should be empty.", (boolean)noWait.containsNoWait(""));
    }

    public void testAddDiscoveredService_FacadeInList_NoWaitNot() {
        String cacheName = "testAddDiscoveredService_FacadeInList_NoWaitNot";
        ArrayList<String> cacheNames = new ArrayList<String>();
        cacheNames.add("testAddDiscoveredService_FacadeInList_NoWaitNot");
        DiscoveredService service = new DiscoveredService();
        service.setCacheNames(cacheNames);
        service.setServiceAddress("localhost");
        service.setServicePort(9999);
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTcpServer(service.getServiceAddress() + ":" + service.getServicePort());
        lca.setCacheName("testAddDiscoveredService_FacadeInList_NoWaitNot");
        LateralCacheNoWait noWait = this.factory.createCacheNoWait((ITCPLateralCacheAttributes)lca, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
        this.cacheMgr.addAuxiliaryCache(this.factory.getName(), "testAddDiscoveredService_FacadeInList_NoWaitNot", (AuxiliaryCache)noWait);
        this.cacheMgr.registryFacPut((AuxiliaryCacheFactory)this.factory);
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testAddDiscoveredService_FacadeInList_NoWaitNot");
        this.listener.addNoWaitFacade("testAddDiscoveredService_FacadeInList_NoWaitNot", facade);
        this.listener.addDiscoveredService(service);
        LateralTCPDiscoveryListenerUnitTest.assertTrue((String)"Should have no wait.", (boolean)this.listener.containsNoWait("testAddDiscoveredService_FacadeInList_NoWaitNot", noWait));
    }

    public void testRemoveDiscoveredService_FacadeInList_NoWaitIs() {
        String cacheName = "testRemoveDiscoveredService_FacadeInList_NoWaitIs";
        ArrayList<String> cacheNames = new ArrayList<String>();
        cacheNames.add("testRemoveDiscoveredService_FacadeInList_NoWaitIs");
        DiscoveredService service = new DiscoveredService();
        service.setCacheNames(cacheNames);
        service.setServiceAddress("localhost");
        service.setServicePort(9999);
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTcpServer(service.getServiceAddress() + ":" + service.getServicePort());
        lca.setCacheName("testRemoveDiscoveredService_FacadeInList_NoWaitIs");
        LateralCacheNoWait noWait = this.factory.createCacheNoWait((ITCPLateralCacheAttributes)lca, (ICacheEventLogger)this.cacheEventLogger, this.elementSerializer);
        this.cacheMgr.addAuxiliaryCache(this.factory.getName(), "testRemoveDiscoveredService_FacadeInList_NoWaitIs", (AuxiliaryCache)noWait);
        this.cacheMgr.registryFacPut((AuxiliaryCacheFactory)this.factory);
        LateralCacheNoWaitFacade<String, String> facade = this.setupFacade("testRemoveDiscoveredService_FacadeInList_NoWaitIs");
        this.listener.addNoWaitFacade("testRemoveDiscoveredService_FacadeInList_NoWaitIs", facade);
        this.listener.addDiscoveredService(service);
        this.listener.removeDiscoveredService(service);
        LateralTCPDiscoveryListenerUnitTest.assertFalse((String)"Should not have no wait.", (boolean)this.listener.containsNoWait("testRemoveDiscoveredService_FacadeInList_NoWaitIs", noWait));
    }
}

