/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.AbstractCombinerTest;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.UnionCombiner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnionCombiner
extends AbstractCombinerTest {
    @Override
    protected NodeCombiner createCombiner() {
        return new UnionCombiner();
    }

    @Test
    public void testAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assertions.assertEquals((int)1, (int)config.getInt("database.tables.table(0)[@id](0)"));
    }

    @Test
    public void testLists() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)2, (int)config.getMaxIndex("net.service.url"));
        Assertions.assertEquals((Object)"http://service1.org", (Object)config.getString("net.service.url(0)"));
        Assertions.assertEquals((Object)"http://service2.org", (Object)config.getString("net.service.url(1)"));
        Assertions.assertEquals((int)2, (int)config.getInt("net.service.url(2)[@type]"));
        Assertions.assertEquals((int)3, (int)config.getMaxIndex("net.server.url"));
    }

    @Test
    public void testSimpleValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)1, (int)config.getMaxIndex("gui.bgcolor"));
        Assertions.assertEquals((Object)"green", (Object)config.getString("gui.bgcolor(0)"));
        Assertions.assertEquals((Object)"black", (Object)config.getString("gui.bgcolor(1)"));
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("gui.selcolor"));
        Assertions.assertEquals((Object)"yellow", (Object)config.getString("gui.selcolor"));
    }

    @Test
    public void testSimpleValuesWithAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)1, (int)config.getMaxIndex("gui.level"));
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level(0)"));
        Assertions.assertEquals((int)4, (int)config.getInt("gui.level(1)"));
        Assertions.assertEquals((int)2, (int)config.getInt("gui.level(0)[@default]"));
        Assertions.assertFalse((boolean)config.containsKey("gui.level(0)[@min]"));
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level(1)[@min]"));
    }

    @Test
    public void testTableList() throws ConfigurationException {
        this.combiner.addListNode("table");
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((Object)"documents", (Object)config.getString("database.tables.table(0).name"));
        Assertions.assertEquals((int)1, (int)config.getInt("database.tables.table(0)[@id]"));
        Assertions.assertEquals((Object)"tasks", (Object)config.getString("database.tables.table(1).name"));
        Assertions.assertEquals((int)2, (int)config.getInt("database.tables.table(1)[@id]"));
    }
}

