/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationNodePointerFactory
extends AbstractXPathTest {
    JXPathContext context;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
        this.context = JXPathContext.newContext((Object)this.root);
        this.context.setLenient(true);
    }

    @Test
    public void testSimpleXPath() {
        List nodes = this.context.selectNodes("subNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)2L, (long)nodes.size());
        for (ConfigurationNode node : nodes) {
            Assert.assertEquals((String)"Incorrect node name", (Object)"subNode", (Object)node.getName());
            Assert.assertEquals((String)"Incorrect parent node", (Object)this.root, (Object)node.getParentNode());
        }
        nodes = this.context.selectNodes("/subNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)2L, (long)nodes.size());
        nodes = this.context.selectNodes("childNode/subNode/childNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)18L, (long)nodes.size());
    }

    @Test
    public void testIndices() {
        Assert.assertEquals((String)"Incorrect value", (Object)"1.2.3", (Object)this.context.getValue("/childNode[1]/subNode[1]/childNode[2]"));
        Assert.assertEquals((String)"Incorrect value of last node", (Object)String.valueOf(5), (Object)this.context.getValue("childNode[last()]"));
        List nodes = this.context.selectNodes("/subNode[1]/*");
        Assert.assertEquals((String)"Wrong number of children", (long)5L, (long)nodes.size());
        int index = 1;
        for (ConfigurationNode node : nodes) {
            Assert.assertEquals((String)("Wrong node value for child " + index), (Object)("2." + index), (Object)node.getValue());
            ++index;
        }
    }

    @Test
    public void testAttributes() {
        this.root.addAttribute((ConfigurationNode)new DefaultConfigurationNode("testAttr", (Object)"true"));
        Assert.assertEquals((String)"Did not find attribute of root node", (Object)"true", (Object)this.context.getValue("@testAttr"));
        Assert.assertEquals((String)"Incorrect attribute value", (Object)"1", (Object)this.context.getValue("/childNode[1]/@counter"));
        Assert.assertTrue((String)"Found elements with name attribute", (boolean)this.context.selectNodes("//childNode[@name]").isEmpty());
        ConfigurationNode node = (ConfigurationNode)this.root.getChild(2).getChild(1).getChildren("childNode").get(1);
        node.addAttribute((ConfigurationNode)new DefaultConfigurationNode("name", (Object)"testValue"));
        List nodes = this.context.selectNodes("//childNode[@name]");
        Assert.assertEquals((String)"Name attribute not found", (long)1L, (long)nodes.size());
        Assert.assertEquals((String)"Wrong node returned", (Object)node, nodes.get(0));
    }

    @Test
    public void testText() {
        List nodes = this.context.selectNodes("//childNode[text()='1.1.1']");
        Assert.assertEquals((String)"Incorrect number of result nodes", (long)1L, (long)nodes.size());
    }

    @Test
    public void testParentAxis() {
        List nodes = this.context.selectNodes("/childNode/parent::*");
        Assert.assertEquals((String)"Wrong number of parent nodes", (long)1L, (long)nodes.size());
    }

    @Test
    public void testFollowingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/following-sibling::*");
        Assert.assertEquals((String)"Wrong number of following siblings", (long)1L, (long)nodes.size());
        ConfigurationNode node = (ConfigurationNode)nodes.get(0);
        Assert.assertEquals((String)"Wrong node type", (Object)"childNode", (Object)node.getName());
        Assert.assertEquals((String)"Wrong index", (Object)String.valueOf(5), (Object)node.getValue());
    }

    @Test
    public void testPrecedingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/preceding-sibling::*");
        Assert.assertEquals((String)"Wrong number of preceding siblings", (long)3L, (long)nodes.size());
        int index = 0;
        int value = 3;
        while (index < nodes.size()) {
            Assert.assertEquals((String)"Wrong node index", (Object)String.valueOf(value), (Object)((ConfigurationNode)nodes.get(index)).getValue());
            ++index;
            --value;
        }
    }
}

