/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultBeanFactory {
    DefaultBeanFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new DefaultBeanFactory();
    }

    @Test
    public void testGetDefaultBeanClass() {
        Assert.assertNull((String)"Default class is not null", (Object)this.factory.getDefaultBeanClass());
    }

    @Test
    public void testCreateBean() throws Exception {
        Object bean = this.factory.createBean(PropertiesConfiguration.class, (BeanDeclaration)new TestBeanDeclaration(), null);
        Assert.assertNotNull((String)"New bean is null", (Object)bean);
        Assert.assertEquals((String)"Bean is of wrong class", PropertiesConfiguration.class, bean.getClass());
        PropertiesConfiguration config = (PropertiesConfiguration)bean;
        Assert.assertTrue((String)"Bean was not initialized", (boolean)config.isThrowExceptionOnMissing());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestBeanDeclaration
    implements BeanDeclaration {
        TestBeanDeclaration() {
        }

        public String getBeanFactoryName() {
            return null;
        }

        public Object getBeanFactoryParameter() {
            return null;
        }

        public String getBeanClassName() {
            return null;
        }

        public Map<String, Object> getBeanProperties() {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("throwExceptionOnMissing", Boolean.TRUE);
            return props;
        }

        public Map<String, Object> getNestedBeanDeclarations() {
            return null;
        }
    }
}

