/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import junitx.framework.ListAssert;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.InterpolationTestHelper;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBaseConfiguration {
    static final String KEY_NUMBER = "number";
    protected BaseConfiguration config = null;
    protected static Class<?> missingElementException = NoSuchElementException.class;
    protected static Class<?> incompatibleElementException = ConversionException.class;

    @Before
    public void setUp() throws Exception {
        this.config = new BaseConfiguration();
        this.config.setThrowExceptionOnMissing(true);
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assert.assertTrue((String)"Throw Exception Property is not set!", (boolean)this.config.isThrowExceptionOnMissing());
    }

    @Test
    public void testGetProperty() {
        Assert.assertEquals((String)"This returns null", (Object)this.config.getProperty("foo"), null);
        this.config.setProperty(KEY_NUMBER, (Object)"1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.config.getProperty(KEY_NUMBER), (Object)"1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.config.getString(KEY_NUMBER), (Object)"1");
    }

    @Test
    public void testGetByte() {
        this.config.setProperty(KEY_NUMBER, (Object)"1");
        byte oneB = 1;
        byte twoB = 2;
        Assert.assertEquals((String)"This returns 1(byte)", (long)oneB, (long)this.config.getByte(KEY_NUMBER));
        Assert.assertEquals((String)"This returns 1(byte)", (long)oneB, (long)this.config.getByte(KEY_NUMBER, twoB));
        Assert.assertEquals((String)"This returns 2(default byte)", (long)twoB, (long)this.config.getByte("numberNotInConfig", twoB));
        Assert.assertEquals((String)"This returns 1(Byte)", (Object)new Byte(oneB), (Object)this.config.getByte(KEY_NUMBER, new Byte("2")));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetByteUnknown() {
        this.config.getByte("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetByteIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getByte("test.empty");
    }

    @Test
    public void testGetShort() {
        this.config.setProperty("numberS", (Object)"1");
        short oneS = 1;
        short twoS = 2;
        Assert.assertEquals((String)"This returns 1(short)", (long)oneS, (long)this.config.getShort("numberS"));
        Assert.assertEquals((String)"This returns 1(short)", (long)oneS, (long)this.config.getShort("numberS", twoS));
        Assert.assertEquals((String)"This returns 2(default short)", (long)twoS, (long)this.config.getShort("numberNotInConfig", twoS));
        Assert.assertEquals((String)"This returns 1(Short)", (Object)new Short(oneS), (Object)this.config.getShort("numberS", new Short("2")));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetShortUnknown() {
        this.config.getShort("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetShortIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getShort("test.empty");
    }

    @Test
    public void testGetLong() {
        this.config.setProperty("numberL", (Object)"1");
        long oneL = 1L;
        long twoL = 2L;
        Assert.assertEquals((String)"This returns 1(long)", (long)oneL, (long)this.config.getLong("numberL"));
        Assert.assertEquals((String)"This returns 1(long)", (long)oneL, (long)this.config.getLong("numberL", twoL));
        Assert.assertEquals((String)"This returns 2(default long)", (long)twoL, (long)this.config.getLong("numberNotInConfig", twoL));
        Assert.assertEquals((String)"This returns 1(Long)", (Object)new Long(oneL), (Object)this.config.getLong("numberL", new Long("2")));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetLongUnknown() {
        this.config.getLong("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetLongIncompatibleTypes() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getLong("test.empty");
    }

    @Test
    public void testGetFloat() {
        this.config.setProperty("numberF", (Object)"1.0");
        float oneF = 1.0f;
        float twoF = 2.0f;
        Assert.assertEquals((String)"This returns 1(float)", (float)oneF, (float)this.config.getFloat("numberF"), (float)0.0f);
        Assert.assertEquals((String)"This returns 1(float)", (float)oneF, (float)this.config.getFloat("numberF", twoF), (float)0.0f);
        Assert.assertEquals((String)"This returns 2(default float)", (float)twoF, (float)this.config.getFloat("numberNotInConfig", twoF), (float)0.0f);
        Assert.assertEquals((String)"This returns 1(Float)", (Object)new Float(oneF), (Object)this.config.getFloat("numberF", new Float("2")));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetFloatUnknown() {
        this.config.getFloat("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetFloatIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getFloat("test.empty");
    }

    @Test
    public void testGetDouble() {
        this.config.setProperty("numberD", (Object)"1.0");
        double oneD = 1.0;
        double twoD = 2.0;
        Assert.assertEquals((String)"This returns 1(double)", (double)oneD, (double)this.config.getDouble("numberD"), (double)0.0);
        Assert.assertEquals((String)"This returns 1(double)", (double)oneD, (double)this.config.getDouble("numberD", twoD), (double)0.0);
        Assert.assertEquals((String)"This returns 2(default double)", (double)twoD, (double)this.config.getDouble("numberNotInConfig", twoD), (double)0.0);
        Assert.assertEquals((String)"This returns 1(Double)", (Object)new Double(oneD), (Object)this.config.getDouble("numberD", new Double("2")));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetDoubleUnknown() {
        this.config.getDouble("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetDoubleIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getDouble("test.empty");
    }

    @Test
    public void testGetBigDecimal() {
        this.config.setProperty("numberBigD", (Object)"123.456");
        BigDecimal number = new BigDecimal("123.456");
        BigDecimal defaultValue = new BigDecimal("654.321");
        Assert.assertEquals((String)"Existing key", (Object)number, (Object)this.config.getBigDecimal("numberBigD"));
        Assert.assertEquals((String)"Existing key with default value", (Object)number, (Object)this.config.getBigDecimal("numberBigD", defaultValue));
        Assert.assertEquals((String)"Missing key with default value", (Object)defaultValue, (Object)this.config.getBigDecimal("numberNotInConfig", defaultValue));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetBigDecimalUnknown() {
        this.config.getBigDecimal("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetBigDecimalIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBigDecimal("test.empty");
    }

    @Test
    public void testGetBigInteger() {
        this.config.setProperty("numberBigI", (Object)"1234567890");
        BigInteger number = new BigInteger("1234567890");
        BigInteger defaultValue = new BigInteger("654321");
        Assert.assertEquals((String)"Existing key", (Object)number, (Object)this.config.getBigInteger("numberBigI"));
        Assert.assertEquals((String)"Existing key with default value", (Object)number, (Object)this.config.getBigInteger("numberBigI", defaultValue));
        Assert.assertEquals((String)"Missing key with default value", (Object)defaultValue, (Object)this.config.getBigInteger("numberNotInConfig", defaultValue));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetBigIntegerUnknown() {
        this.config.getBigInteger("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetBigIntegerIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBigInteger("test.empty");
    }

    @Test
    public void testGetString() {
        this.config.setProperty("testString", (Object)"The quick brown fox");
        String string = "The quick brown fox";
        String defaultValue = "jumps over the lazy dog";
        Assert.assertEquals((String)"Existing key", (Object)string, (Object)this.config.getString("testString"));
        Assert.assertEquals((String)"Existing key with default value", (Object)string, (Object)this.config.getString("testString", defaultValue));
        Assert.assertEquals((String)"Missing key with default value", (Object)defaultValue, (Object)this.config.getString("stringNotInConfig", defaultValue));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetStringUnknown() {
        this.config.getString("stringNotInConfig");
    }

    @Test
    public void testGetBoolean() {
        this.config.setProperty("boolA", (Object)Boolean.TRUE);
        boolean boolT = true;
        boolean boolF = false;
        Assert.assertEquals((String)"This returns true", (Object)boolT, (Object)this.config.getBoolean("boolA"));
        Assert.assertEquals((String)"This returns true, not the default", (Object)boolT, (Object)this.config.getBoolean("boolA", boolF));
        Assert.assertEquals((String)"This returns false(default)", (Object)boolF, (Object)this.config.getBoolean("boolNotInConfig", boolF));
        Assert.assertEquals((String)"This returns true(Boolean)", (Object)new Boolean(boolT), (Object)this.config.getBoolean("boolA", new Boolean(boolF)));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetBooleanUnknown() {
        this.config.getBoolean("numberNotInConfig");
    }

    @Test(expected=ConversionException.class)
    public void testGetBooleanIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBoolean("test.empty");
    }

    @Test
    public void testGetList() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty(KEY_NUMBER, (Object)"2");
        List list = this.config.getList(KEY_NUMBER);
        Assert.assertNotNull((String)"The list is null", (Object)list);
        Assert.assertEquals((String)"List size", (long)2L, (long)list.size());
        Assert.assertTrue((String)"The number 1 is missing from the list", (boolean)list.contains("1"));
        Assert.assertTrue((String)"The number 2 is missing from the list", (boolean)list.contains("2"));
    }

    @Test
    public void testGetStringForListValue() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty(KEY_NUMBER, (Object)"2");
        Assert.assertEquals((String)"Wrong result", (Object)"1", (Object)this.config.getString(KEY_NUMBER));
    }

    @Test
    public void testGetInterpolatedList() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty("array", (Object)"${number}");
        this.config.addProperty("array", (Object)"${number}");
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("1");
        ListAssert.assertEquals((String)"'array' property", list, (List)this.config.getList("array"));
    }

    @Test
    public void testGetInterpolatedPrimitives() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty("value", (Object)"${number}");
        this.config.addProperty("boolean", (Object)"true");
        this.config.addProperty("booleanValue", (Object)"${boolean}");
        Assert.assertEquals((String)"boolean interpolation", (Object)true, (Object)this.config.getBoolean("booleanValue"));
        Assert.assertEquals((String)"byte interpolation", (long)1L, (long)this.config.getByte("value"));
        Assert.assertEquals((String)"short interpolation", (long)1L, (long)this.config.getShort("value"));
        Assert.assertEquals((String)"int interpolation", (long)1L, (long)this.config.getInt("value"));
        Assert.assertEquals((String)"long interpolation", (long)1L, (long)this.config.getLong("value"));
        Assert.assertEquals((String)"float interpolation", (float)1.0f, (float)this.config.getFloat("value"), (float)0.0f);
        Assert.assertEquals((String)"double interpolation", (double)1.0, (double)this.config.getDouble("value"), (double)0.0);
        Assert.assertEquals((String)"Boolean interpolation", (Object)Boolean.TRUE, (Object)this.config.getBoolean("booleanValue", null));
        Assert.assertEquals((String)"Byte interpolation", (Object)new Byte("1"), (Object)this.config.getByte("value", null));
        Assert.assertEquals((String)"Short interpolation", (Object)new Short("1"), (Object)this.config.getShort("value", null));
        Assert.assertEquals((String)"Integer interpolation", (Object)new Integer("1"), (Object)this.config.getInteger("value", null));
        Assert.assertEquals((String)"Long interpolation", (Object)new Long("1"), (Object)this.config.getLong("value", null));
        Assert.assertEquals((String)"Float interpolation", (Object)new Float("1"), (Object)this.config.getFloat("value", null));
        Assert.assertEquals((String)"Double interpolation", (Object)new Double("1"), (Object)this.config.getDouble("value", null));
        Assert.assertEquals((String)"BigInteger interpolation", (Object)new BigInteger("1"), (Object)this.config.getBigInteger("value", null));
        Assert.assertEquals((String)"BigDecimal interpolation", (Object)new BigDecimal("1"), (Object)this.config.getBigDecimal("value", null));
    }

    @Test
    public void testCommaSeparatedString() {
        String prop = "hey, that's a test";
        this.config.setProperty("prop.string", (Object)prop);
        List list = this.config.getList("prop.string");
        Assert.assertEquals((String)"Wrong number of list elements", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"hey", list.get(0));
    }

    @Test
    public void testCommaSeparatedStringEscaped() {
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)prop2);
        Assert.assertEquals((String)"Wrong value", (Object)"hey, that's a test", (Object)this.config.getString("prop.string"));
    }

    @Test
    public void testAddProperty() throws Exception {
        ArrayList<Object> props = new ArrayList<Object>();
        props.add("one");
        props.add("two,three,four");
        props.add(new String[]{"5.1", "5.2", "5.3,5.4", "5.5"});
        props.add("six");
        this.config.addProperty("complex.property", props);
        Object val = this.config.getProperty("complex.property");
        Assert.assertTrue((boolean)(val instanceof Collection));
        Collection col = (Collection)val;
        Assert.assertEquals((long)10L, (long)col.size());
        props = new ArrayList();
        props.add("quick");
        props.add("brown");
        props.add("fox,jumps");
        Object[] data = new Object[]{"The", props, "over,the", "lazy", "dog."};
        this.config.setProperty("complex.property", (Object)data);
        val = this.config.getProperty("complex.property");
        Assert.assertTrue((boolean)(val instanceof Collection));
        col = (Collection)val;
        Iterator it = col.iterator();
        StringTokenizer tok = new StringTokenizer("The quick brown fox jumps over the lazy dog.", " ");
        while (tok.hasMoreTokens()) {
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)tok.nextToken(), it.next());
        }
        Assert.assertFalse((boolean)it.hasNext());
        this.config.setProperty("complex.property", null);
        Assert.assertFalse((boolean)this.config.containsKey("complex.property"));
    }

    @Test
    public void testPropertyAccess() {
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"");
        Assert.assertEquals((String)"This returns an empty Properties object", (Object)this.config.getProperties("prop.properties"), (Object)new Properties());
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"foo=bar, baz=moo, seal=clubber");
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("baz", "moo");
        p.setProperty("seal", "clubber");
        Assert.assertEquals((String)"This returns a filled in Properties object", (Object)this.config.getProperties("prop.properties"), (Object)p);
    }

    @Test
    public void testSubset() {
        String prop = "hey, that's a test";
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)prop2);
        this.config.setProperty("property.string", (Object)"hello");
        Configuration subEprop = this.config.subset("prop");
        Assert.assertEquals((String)"Returns the full string", (Object)prop, (Object)subEprop.getString("string"));
        Assert.assertEquals((String)"Wrong list size", (long)1L, (long)subEprop.getList("string").size());
        Iterator it = subEprop.getKeys();
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        subEprop = this.config.subset("prop.");
        it = subEprop.getKeys();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testInterpolation() {
        InterpolationTestHelper.testInterpolation((Configuration)this.config);
    }

    @Test
    public void testMultipleInterpolation() {
        InterpolationTestHelper.testMultipleInterpolation((Configuration)this.config);
    }

    @Test
    public void testInterpolationLoop() {
        InterpolationTestHelper.testInterpolationLoop((Configuration)this.config);
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset((Configuration)this.config);
    }

    @Test
    public void testInterpolationUnknownProperty() {
        InterpolationTestHelper.testInterpolationUnknownProperty((Configuration)this.config);
    }

    @Test
    public void testInterpolationSystemProperties() {
        InterpolationTestHelper.testInterpolationSystemProperties((Configuration)this.config);
    }

    @Test
    public void testInterpolationConstants() {
        InterpolationTestHelper.testInterpolationConstants((Configuration)this.config);
    }

    @Test
    public void testInterpolationEscaped() {
        InterpolationTestHelper.testInterpolationEscaped((Configuration)this.config);
    }

    @Test
    public void testGetInterpolator() {
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testInterpolatedConfiguration() {
        InterpolationTestHelper.testInterpolatedConfiguration((AbstractConfiguration)this.config);
    }

    @Test
    public void testGetHexadecimalValue() {
        this.config.setProperty(KEY_NUMBER, (Object)"0xFF");
        Assert.assertEquals((String)"byte value", (long)-1L, (long)this.config.getByte(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFF");
        Assert.assertEquals((String)"short value", (long)-1L, (long)this.config.getShort(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFFFFFF");
        Assert.assertEquals((String)"int value", (long)-1L, (long)this.config.getInt(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFFFFFFFFFFFFFF");
        Assert.assertEquals((String)"long value", (long)-1L, (long)this.config.getLong(KEY_NUMBER));
        Assert.assertEquals((String)"long value", (long)-1L, (long)this.config.getBigInteger(KEY_NUMBER).longValue());
    }

    @Test
    public void testGetBinaryValue() {
        this.config.setProperty(KEY_NUMBER, (Object)"0b11111111");
        Assert.assertEquals((String)"byte value", (long)-1L, (long)this.config.getByte(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b1111111111111111");
        Assert.assertEquals((String)"short value", (long)-1L, (long)this.config.getShort(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b11111111111111111111111111111111");
        Assert.assertEquals((String)"int value", (long)-1L, (long)this.config.getInt(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b1111111111111111111111111111111111111111111111111111111111111111");
        Assert.assertEquals((String)"long value", (long)-1L, (long)this.config.getLong(KEY_NUMBER));
        Assert.assertEquals((String)"long value", (long)-1L, (long)this.config.getBigInteger(KEY_NUMBER).longValue());
    }

    @Test
    public void testResolveContainerStore() {
        BaseConfiguration config = new BaseConfiguration();
        config.addPropertyDirect("array", (Object)new String[]{"foo", "bar"});
        Assert.assertEquals((String)"first element of the 'array' property", (Object)"foo", (Object)config.resolveContainerStore("array"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        config.addPropertyDirect("list", list);
        Assert.assertEquals((String)"first element of the 'list' property", (Object)"foo", (Object)config.resolveContainerStore("list"));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("foo");
        set.add("bar");
        config.addPropertyDirect("set", set);
        Assert.assertEquals((String)"first element of the 'set' property", (Object)"foo", (Object)config.resolveContainerStore("set"));
        config.addPropertyDirect("array.boolean", (Object)new boolean[]{true, false});
        Assert.assertEquals((String)"first element of the 'array.boolean' property", (Object)true, (Object)config.getBoolean("array.boolean"));
        config.addPropertyDirect("array.byte", (Object)new byte[]{1, 2});
        Assert.assertEquals((String)"first element of the 'array.byte' property", (long)1L, (long)config.getByte("array.byte"));
        config.addPropertyDirect("array.short", (Object)new short[]{1, 2});
        Assert.assertEquals((String)"first element of the 'array.short' property", (long)1L, (long)config.getShort("array.short"));
        config.addPropertyDirect("array.int", (Object)new int[]{1, 2});
        Assert.assertEquals((String)"first element of the 'array.int' property", (long)1L, (long)config.getInt("array.int"));
        config.addPropertyDirect("array.long", (Object)new long[]{1L, 2L});
        Assert.assertEquals((String)"first element of the 'array.long' property", (long)1L, (long)config.getLong("array.long"));
        config.addPropertyDirect("array.float", (Object)new float[]{1.0f, 2.0f});
        Assert.assertEquals((String)"first element of the 'array.float' property", (float)1.0f, (float)config.getFloat("array.float"), (float)0.0f);
        config.addPropertyDirect("array.double", (Object)new double[]{1.0, 2.0});
        Assert.assertEquals((String)"first element of the 'array.double' property", (double)1.0, (double)config.getDouble("array.double"), (double)0.0);
    }

    @Test
    public void testNumberConversions() {
        this.config.setProperty(KEY_NUMBER, (Object)new Integer(42));
        Assert.assertEquals((String)"Wrong int returned", (long)42L, (long)this.config.getInt(KEY_NUMBER));
        Assert.assertEquals((String)"Wrong long returned", (long)42L, (long)this.config.getLong(KEY_NUMBER));
        Assert.assertEquals((String)"Wrong byte returned", (long)42L, (long)this.config.getByte(KEY_NUMBER));
        Assert.assertEquals((String)"Wrong float returned", (float)42.0f, (float)this.config.getFloat(KEY_NUMBER), (float)0.01f);
        Assert.assertEquals((String)"Wrong double returned", (double)42.0, (double)this.config.getDouble(KEY_NUMBER), (double)0.001);
        Assert.assertEquals((String)"Wrong Long returned", (Object)new Long(42L), (Object)this.config.getLong(KEY_NUMBER, null));
        Assert.assertEquals((String)"Wrong BigInt returned", (Object)new BigInteger("42"), (Object)this.config.getBigInteger(KEY_NUMBER));
        Assert.assertEquals((String)"Wrong DigDecimal returned", (Object)new BigDecimal("42"), (Object)this.config.getBigDecimal(KEY_NUMBER));
    }

    @Test
    public void testClone() {
        for (int i = 0; i < 10; ++i) {
            this.config.addProperty("key" + i, (Object)new Integer(i));
        }
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("Key not found: " + key), (boolean)config2.containsKey(key));
            Assert.assertEquals((String)("Wrong value for key " + key), (Object)this.config.getProperty(key), (Object)config2.getProperty(key));
        }
    }

    @Test
    public void testCloneModify() {
        ConfigurationListener l = new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
            }
        };
        this.config.addConfigurationListener(l);
        this.config.addProperty("original", (Object)Boolean.TRUE);
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        config2.addProperty("clone", (Object)Boolean.TRUE);
        Assert.assertFalse((String)"New key appears in original", (boolean)this.config.containsKey("clone"));
        config2.setProperty("original", (Object)Boolean.FALSE);
        Assert.assertTrue((String)"Wrong value of original property", (boolean)this.config.getBoolean("original"));
        Assert.assertEquals((String)"Event listener was copied", (long)0L, (long)config2.getConfigurationListeners().size());
    }

    @Test
    public void testCloneListProperty() {
        String key = "list";
        this.config.addProperty("list", (Object)"value1");
        this.config.addProperty("list", (Object)"value2");
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        config2.addProperty("list", (Object)"value3");
        Assert.assertEquals((String)"Wrong number of original properties", (long)2L, (long)this.config.getList("list").size());
    }
}

