/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPredicate<T>
implements Predicate<T> {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Predicate<T> predicate;

    public BeanPredicate(String propertyName, Predicate<T> predicate) {
        this.propertyName = propertyName;
        this.predicate = predicate;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public boolean test(Object object) {
        boolean evaluation = false;
        try {
            Object propValue = PropertyUtils.getProperty(object, this.propertyName);
            evaluation = this.predicate.test(propValue);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during evaluation.";
            this.log.error((Object)"Problem during evaluation.", (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error((Object)"Unable to access the property provided.", (Throwable)e);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error((Object)"Exception occurred in property's getter", (Throwable)e);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "Property not found.";
            this.log.error((Object)"Property not found.", (Throwable)e);
            throw new IllegalArgumentException("Property not found.");
        }
        return evaluation;
    }
}

