/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.builder.SourceFile;

public class CompilationParticipantResult
extends BuildContext {
    protected SourceFile sourceFile;
    protected AnnotationBinding[] annotations;
    protected IFile[] addedFiles;
    protected IFile[] deletedFiles;
    protected CategorizedProblem[] problems;
    protected String[] dependencies;
    private final boolean isTestCode;

    protected CompilationParticipantResult(SourceFile sourceFile, boolean isTestCode) {
        this.sourceFile = sourceFile;
        this.isTestCode = isTestCode;
        this.annotations = null;
        this.addedFiles = null;
        this.deletedFiles = null;
        this.problems = null;
        this.dependencies = null;
    }

    @Override
    public char[] getContents() {
        return this.sourceFile.getContents();
    }

    @Override
    public IFile getFile() {
        return this.sourceFile.resource;
    }

    @Override
    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public boolean hasAnnotations(String fqn) {
        if (this.annotations != null) {
            AnnotationBinding[] annotationBindingArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding type;
                AnnotationBinding binding = annotationBindingArray[n2];
                if (binding != null && (type = binding.getAnnotationType()) != null && type.compoundName != null && fqn.equals(new String(CharOperation.concatWith((char[][])type.compoundName, (char)'.')))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void recordAddedGeneratedFiles(IFile[] addedGeneratedFiles) {
        int length2 = addedGeneratedFiles.length;
        if (length2 == 0) {
            return;
        }
        int length1 = this.addedFiles == null ? 0 : this.addedFiles.length;
        IFile[] merged = new IFile[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(this.addedFiles, 0, merged, 0, length1);
        }
        System.arraycopy(addedGeneratedFiles, 0, merged, length1, length2);
        this.addedFiles = merged;
    }

    @Override
    public void recordDeletedGeneratedFiles(IFile[] deletedGeneratedFiles) {
        int length2 = deletedGeneratedFiles.length;
        if (length2 == 0) {
            return;
        }
        int length1 = this.deletedFiles == null ? 0 : this.deletedFiles.length;
        IFile[] merged = new IFile[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(this.deletedFiles, 0, merged, 0, length1);
        }
        System.arraycopy(deletedGeneratedFiles, 0, merged, length1, length2);
        this.deletedFiles = merged;
    }

    @Override
    public void recordDependencies(String[] typeNameDependencies) {
        int length2 = typeNameDependencies.length;
        if (length2 == 0) {
            return;
        }
        int length1 = this.dependencies == null ? 0 : this.dependencies.length;
        String[] merged = new String[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(this.dependencies, 0, merged, 0, length1);
        }
        System.arraycopy(typeNameDependencies, 0, merged, length1, length2);
        this.dependencies = merged;
    }

    @Override
    public void recordNewProblems(CategorizedProblem[] newProblems) {
        int length2 = newProblems.length;
        if (length2 == 0) {
            return;
        }
        int length1 = this.problems == null ? 0 : this.problems.length;
        CategorizedProblem[] merged = new CategorizedProblem[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(this.problems, 0, merged, 0, length1);
        }
        System.arraycopy(newProblems, 0, merged, length1, length2);
        this.problems = merged;
    }

    void reset(AnnotationBinding[] newAnnotations) {
        this.annotations = newAnnotations;
        this.addedFiles = null;
        this.deletedFiles = null;
        this.problems = null;
        this.dependencies = null;
    }

    public String toString() {
        return this.sourceFile.toString();
    }

    @Override
    public boolean isTestCode() {
        return this.isTestCode;
    }
}

