/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.jface.text;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.rcptt.tesla.core.protocol.TextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.IJFaceTextEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.JFaceTextEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessorExtension;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class JFaceTextRecordingProcessor
implements IRecordingProcessor,
IJFaceTextEventListener {
    private TeslaRecorder recorder;
    private SWTEventRecorder eventRecorder;

    public void clear() {
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
        JFaceTextEventManager.addListener((IJFaceTextEventListener)this);
    }

    public int getInitLevel() {
        return 200;
    }

    public TeslaRecorder getRecorder() {
        return this.recorder;
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public static ContentAssistant getContentAssistant(Object control) {
        try {
            Field field = control.getClass().getDeclaredField("fContentAssistant");
            if (field != null) {
                field.setAccessible(true);
                Object value = field.get(control);
                if (value instanceof ContentAssistant) {
                    return (ContentAssistant)value;
                }
            }
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    public IContentAssistSubjectControl getSubjectControl(Object control) {
        try {
            Field field = control.getClass().getDeclaredField("fContentAssistSubjectControlAdapter");
            if (field != null) {
                field.setAccessible(true);
                Object value = field.get(control);
                if (value instanceof IContentAssistSubjectControl) {
                    return (IContentAssistSubjectControl)value;
                }
            }
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
        return null;
    }

    private synchronized SWTEventRecorder getSWTEventRecorder() {
        if (this.eventRecorder == null) {
            this.eventRecorder = (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.eventRecorder;
    }

    public void showContentAssist(Object control, boolean autoActivation) {
        FindResult textWidget;
        Control subjControl;
        IContentAssistSubjectControl subjectControl;
        if (this.getRecorder() == null) {
            return;
        }
        if (!this.getRecorder().hasListeners()) {
            return;
        }
        if (autoActivation && (subjectControl = this.getSubjectControl(control)) != null && (subjControl = subjectControl.getControl()) != null && (textWidget = this.getSWTEventRecorder().getLocator().findElement((Widget)subjControl, false, false, true)) != null) {
            TextUIElement text = new TextUIElement(textWidget.element, (UIPlayer)this.getRecorder());
            text.showContentAssist();
        }
    }

    public void activateInfomationWindow(Widget widget, Rectangle subjectArea) {
        List processors = this.getRecorder().getProcessors(IRecordingProcessorExtension.class);
        if (!(widget instanceof StyledText)) {
            return;
        }
        for (IRecordingProcessorExtension ext : processors) {
            if (!ext.isIgnored((Object)widget, 13, null)) continue;
            return;
        }
        FindResult findResult = this.getSWTEventRecorder().getLocator().findElement(widget, false, false, true);
        if (findResult != null) {
            StyledText text = (StyledText)widget;
            Point center = new Point(subjectArea.x + subjectArea.width / 2, subjectArea.y + subjectArea.height / 2);
            int offset = ((StyledText)widget).getOffsetAtLocation(center);
            int lineAtOffset = text.getLineAtOffset(offset);
            int offsetAtLine = offset - text.getOffsetAtLine(lineAtOffset);
            TextUIElement textElement = new TextUIElement(findResult.element, (UIPlayer)this.getRecorder());
            textElement.hoverAtOffset(lineAtOffset, offsetAtLine);
        }
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper getHelper() {
        return null;
    }
}

