/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.verification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.verification.VerificationViewer;

public class VerificationUIManager {
    private static VerificationUIManager instance;
    private static final String EXPT_ID = "org.eclipse.rcptt.ui.verificationViewers";
    private VerificationViewer[] viewers = null;
    private Map<VerificationType, VerificationViewer> typeToViewer;

    public static synchronized VerificationUIManager getInstance() {
        if (instance == null) {
            instance = new VerificationUIManager();
        }
        return instance;
    }

    public ImageDescriptor getIcon(VerificationType type) {
        VerificationViewer viewer = this.getViewer(type);
        if (viewer != null) {
            return viewer.getIcon();
        }
        return null;
    }

    public VerificationViewer getViewer(VerificationType type) {
        this.init();
        return this.typeToViewer.get(type);
    }

    public VerificationViewer[] getViewers() {
        this.init();
        return this.viewers;
    }

    private synchronized void init() {
        IConfigurationElement[] elements;
        if (this.typeToViewer != null) {
            return;
        }
        this.typeToViewer = new HashMap<VerificationType, VerificationViewer>();
        ArrayList<VerificationViewer> list = new ArrayList<VerificationViewer>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                VerificationViewer viewer = new VerificationViewer(element);
                list.add(viewer);
                this.typeToViewer.put(viewer.getType(), viewer);
            }
            catch (CoreException e) {
                Q7UIPlugin.log(e);
            }
            ++n2;
        }
        this.viewers = list.toArray(new VerificationViewer[list.size()]);
    }
}

