/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.gef;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.gef.GefModelMapper;
import org.eclipse.rcptt.tesla.gef.GefUtils;
import org.eclipse.rcptt.tesla.gef.RawFigureUIElement;
import org.eclipse.rcptt.tesla.gef.describers.FigureDescriber;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.gef.RecordingEditPartDescriber;

public class RecordingFigureDescriber
extends FigureDescriber
implements IRecordingDescriber {
    private FigureCanvas canvas;
    protected boolean needLogging;

    public RecordingFigureDescriber(IFigure figure, EditPart editPart, GraphicalViewer viewer, FigureCanvas canvas) {
        super(figure, editPart, viewer);
        this.canvas = canvas;
    }

    public Element searchForElement(TeslaRecorder recorder) {
        RawFigureUIElement uiEl = new RawFigureUIElement(this.getEditPart(), this.getFigure(), this.getViewer());
        BasicRecordingHelper.ElementEntry e = GefRecordingHelper.getHelper().get(uiEl);
        if (e != null) {
            return e.getElement();
        }
        if (this.getEditPart() != null) {
            RecordingEditPartDescriber partDescr = new RecordingEditPartDescriber(this.getEditPart(), (GraphicalViewer)this.getEditPart().getViewer());
            Element element = partDescr.searchForElement(recorder);
            FigureUIElement partElement = new FigureUIElement(element, (UIPlayer)recorder);
            List figureAddress = GefUtils.getAddress((IFigure)this.getFigure(), (IFigure)((GraphicalEditPart)this.getEditPart()).getFigure());
            if (figureAddress.size() != 0) {
                recorder.setControls(new Widget[]{GefModelMapper.figureMap((IFigure)this.getFigure())});
                FigureUIElement rawFigure = partElement.rawFigure(figureAddress);
                GefRecordingHelper.getHelper().put(uiEl, new BasicRecordingHelper.ElementEntry(rawFigure.getElement()));
                return rawFigure.getElement();
            }
            return element;
        }
        return null;
    }

    public org.eclipse.swt.widgets.Widget getWidget() {
        return this.canvas;
    }

    public IRecordingDescriber getParent() {
        if (this.getEditPart() == null) {
            IFigure parent = this.getFigure().getParent();
            if (parent != null) {
                return new RecordingFigureDescriber(parent, null, this.getViewer(), this.canvas);
            }
            return this;
        }
        IFigure fig = ((GraphicalEditPart)this.getEditPart()).getFigure();
        if (fig.equals(this.getFigure())) {
            return new RecordingEditPartDescriber(this.getEditPart(), this.getViewer());
        }
        IFigure parent = this.getFigure().getParent();
        if (parent != null) {
            return new RecordingFigureDescriber(parent, this.getEditPart(), this.getViewer(), this.canvas);
        }
        return this;
    }

    public void setNeedLogging(boolean need) {
        this.needLogging = need;
    }
}

