/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class GitSyncCache {
    private final Map<File, GitSyncObjectCache> cache = new HashMap<File, GitSyncObjectCache>();

    public static GitSyncCache getAllData(GitSynchronizeDataSet gsds, IProgressMonitor monitor) {
        HashMap<GitSynchronizeData, Collection<String>> updateRequests = new HashMap<GitSynchronizeData, Collection<String>>();
        for (GitSynchronizeData data : gsds) {
            updateRequests.put(data, Collections.emptyList());
        }
        return GitSyncCache.getAllData(updateRequests, monitor);
    }

    public static GitSyncCache getAllData(Map<GitSynchronizeData, Collection<String>> updateRequests, IProgressMonitor monitor) {
        GitSyncCache cache = new GitSyncCache();
        GitSyncCache.mergeAllDataIntoCache(updateRequests, monitor, cache);
        return cache;
    }

    public static void mergeAllDataIntoCache(Map<GitSynchronizeData, Collection<String>> updateRequests, IProgressMonitor monitor, GitSyncCache cache) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)updateRequests.size());
        for (Map.Entry<GitSynchronizeData, Collection<String>> entry : updateRequests.entrySet()) {
            Collection<String> paths = entry.getValue();
            GitSyncCache partialCache = GitSyncCache.getAllData(entry.getKey(), paths);
            cache.merge(partialCache, new HashSet<String>(paths));
            m.worked(1);
        }
        m.done();
    }

    private static GitSyncCache getAllData(GitSynchronizeData gsd, Collection<String> paths) {
        GitSyncCache cache = new GitSyncCache();
        TreeFilter filter = GitSyncCache.createPathFilter(paths);
        Repository repo = gsd.getRepository();
        ObjectId baseTree = GitSyncCache.getTree(gsd.getSrcRevCommit());
        ObjectId remoteTree = GitSyncCache.getTree(gsd.getDstRevCommit());
        GitSyncObjectCache repoCache = cache.put(repo, baseTree, remoteTree);
        TreeFilter gsdFilter = gsd.getPathFilter();
        if (filter == null) {
            GitSyncCache.loadDataFromGit(gsd, gsdFilter, repoCache);
        } else if (gsdFilter == null) {
            GitSyncCache.loadDataFromGit(gsd, filter, repoCache);
        } else {
            GitSyncCache.loadDataFromGit(gsd, AndTreeFilter.create((TreeFilter)filter, (TreeFilter)gsdFilter), repoCache);
        }
        return cache;
    }

    private static TreeFilter createPathFilter(Collection<String> paths) {
        if (paths.isEmpty() || paths.stream().anyMatch(s -> s == null || s.isEmpty())) {
            return null;
        }
        return PathFilterGroup.createFromStrings(paths);
    }

    static boolean loadDataFromGit(GitSynchronizeData gsd, TreeFilter filter, GitSyncObjectCache repoCache) {
        Repository repo = gsd.getRepository();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TreeWalk tw = new TreeWalk(repo);){
                if (filter != null) {
                    tw.setFilter(filter);
                }
                FileTreeIterator fti = null;
                if (gsd.shouldIncludeLocal()) {
                    fti = new FileTreeIterator(repo);
                    tw.addTree((AbstractTreeIterator)fti);
                    if (filter != null) {
                        tw.setFilter(AndTreeFilter.create((TreeFilter)filter, (TreeFilter)new NotIgnoredFilter(0)));
                    } else {
                        tw.setFilter((TreeFilter)new NotIgnoredFilter(0));
                    }
                } else if (gsd.getSrcRevCommit() != null) {
                    tw.addTree((AnyObjectId)gsd.getSrcRevCommit().getTree());
                } else {
                    tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                if (gsd.getCommonAncestorRev() != null) {
                    tw.addTree((AnyObjectId)gsd.getCommonAncestorRev().getTree());
                } else {
                    tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                if (gsd.getDstRevCommit() != null) {
                    tw.addTree((AnyObjectId)gsd.getDstRevCommit().getTree());
                } else {
                    tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                DirCacheIterator dci = null;
                if (fti != null) {
                    dci = new DirCacheIterator(DirCache.read((Repository)repo));
                    tw.addTree((AbstractTreeIterator)dci);
                    fti.setDirCacheIterator(tw, 3);
                }
                List<ThreeWayDiffEntry> diffEntrys = ThreeWayDiffEntry.scan(tw, gsd);
                for (ThreeWayDiffEntry diffEntry : diffEntrys) {
                    repoCache.addMember(diffEntry);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
        return true;
    }

    private static ObjectId getTree(RevCommit commit) {
        if (commit != null) {
            return commit.getTree();
        }
        return ObjectId.zeroId();
    }

    private GitSyncCache() {
    }

    public GitSyncObjectCache get(Repository repo) {
        return this.cache.get(repo.getDirectory());
    }

    public void merge(GitSyncCache other, Set<String> filterPaths) {
        for (Map.Entry<File, GitSyncObjectCache> entry : other.cache.entrySet()) {
            File key = entry.getKey();
            if (this.cache.containsKey(key)) {
                this.cache.get(key).merge(entry.getValue(), filterPaths);
                continue;
            }
            this.cache.put(key, entry.getValue());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<File, GitSyncObjectCache> entry : this.cache.entrySet()) {
            builder.append(entry.getKey().getPath()).append(": ").append(entry.getValue());
        }
        return builder.toString();
    }

    private GitSyncObjectCache put(Repository repo, ObjectId baseTree, ObjectId remoteTree) {
        ThreeWayDiffEntry entry = new ThreeWayDiffEntry();
        entry.baseId = AbbreviatedObjectId.fromObjectId((AnyObjectId)baseTree);
        entry.remoteId = AbbreviatedObjectId.fromObjectId((AnyObjectId)remoteTree);
        GitSyncObjectCache objectCache = new GitSyncObjectCache("", entry);
        this.cache.put(repo.getDirectory(), objectCache);
        return objectCache;
    }
}

