/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.ui.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.core.ecl.core.model.GetPerspectives;
import org.eclipse.rcptt.core.ecl.core.model.PerspectiveInfo;
import org.eclipse.rcptt.core.ecl.core.model.PerspectivesList;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.scenario.WorkbenchContext;
import org.eclipse.rcptt.ctx.workbench.ui.views.EditorsTable;
import org.eclipse.rcptt.ctx.workbench.ui.views.PerspectiveLabelProvider;
import org.eclipse.rcptt.ctx.workbench.ui.views.ViewsTable;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.commons.ModernElementListSelectionDialog;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.editors.CompositeNamedElementActions;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.TextNamedElementActions;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkbenchContextEditor
extends BaseContextEditor
implements IQ7EditorActionsProvider {
    private final DataBindingContext dbc = new DataBindingContext();
    private Text perspective;
    private Button resetPerspective;
    private Text nameText;
    private EditorsTable editorsTable;
    private ViewsTable viewsTable;

    public WorkbenchContext getContextElement() {
        try {
            return (WorkbenchContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(composite);
        Section section = new SectionWithComposite("Workbench", 322).numColumns(3).grabVertical(false).create(composite, toolkit);
        Composite c = (Composite)section.getClient();
        this.createPerspective(c, toolkit);
        this.createResetPerspectiveOption(c, toolkit);
        this.createDialogsOption(c, toolkit);
        this.createClipboardOption(c, toolkit);
        Composite composite2 = toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(composite2);
        this.viewsTable = new ViewsTable(this.getContextElement());
        new SectionWithToolbar((IEmbeddedComposite)this.viewsTable, 322).create(composite2, toolkit);
        this.editorsTable = new EditorsTable(this.getContextElement());
        new SectionWithToolbar((IEmbeddedComposite)this.editorsTable, 322).create(composite2, toolkit);
        this.editorsTable.setCloseEditorsControlEnabled(!this.isPerspectiveSelected() || !this.resetPerspective.getSelection());
        return composite;
    }

    private void createPerspective(Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, "Perspective id: ");
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        String id = this.getContextElement().getPerspectiveId();
        if (id == null) {
            id = "";
        }
        this.perspective = toolkit.createText(parent, id, 2048);
        this.perspective.setLayoutData((Object)new GridData(768));
        IObservableValue perspectiveId = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)ScenarioPackage.eINSTANCE.getWorkbenchContext_PerspectiveId());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.perspective), perspectiveId, (UpdateValueStrategy)new PerspectiveChangeListener(), (UpdateValueStrategy)new PerspectiveChangeListener());
        Button button = toolkit.createButton(parent, "Browse...", 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = WorkbenchContextEditor.this.perspective.getShell();
                ModernElementListSelectionDialog dialog = new ModernElementListSelectionDialog(shell, (ILabelProvider)new PerspectiveLabelProvider());
                PerspectivesList perspectives = WorkbenchContextEditor.this.getPerspectives(shell);
                if (perspectives == null) {
                    return;
                }
                dialog.setElements(perspectives.getPerspectives().toArray());
                dialog.setTitle("Select a perspective");
                dialog.setMessage("Select a perspective which should be opened");
                dialog.setMultipleSelection(false);
                dialog.setBlockOnOpen(true);
                int result = dialog.open();
                if (result == 0) {
                    PerspectiveInfo p = (PerspectiveInfo)dialog.getFirstResult();
                    WorkbenchContextEditor.this.getContextElement().setPerspectiveId(p.getId());
                }
            }
        });
    }

    private PerspectivesList getPerspectives(Shell shell) {
        AutLaunch aut = LaunchUtils.selectAutLaunch((Shell)shell);
        if (aut == null) {
            return null;
        }
        try {
            GetPerspectives getPerspectives = Q7CoreFactory.eINSTANCE.createGetPerspectives();
            Object object = aut.execute((Command)getPerspectives);
            if (!(object instanceof PerspectivesList)) {
                throw new CoreException(Q7UIPlugin.createStatus((String)("Unexpected object: " + String.valueOf(object) + ". Context is expected")));
            }
            return (PerspectivesList)object;
        }
        catch (InterruptedException e) {
            return Q7CoreFactory.eINSTANCE.createPerspectivesList();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, (String)"AUT access error", (String)"Couldn't get list of known perspective from AUT", (IStatus)e.getStatus());
            return null;
        }
    }

    private void createResetPerspectiveOption(Composite parent, FormToolkit toolkit) {
        this.resetPerspective = toolkit.createButton(parent, "Reset perspective", 32);
        this.resetPerspective.setEnabled(this.isPerspectiveSelected());
        IObservableValue resetPerspectiveValue = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)ScenarioPackage.eINSTANCE.getWorkbenchContext_ResetPerspective());
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.resetPerspective), resetPerspectiveValue, (UpdateValueStrategy)new ResetPerspectiveChangeListener(), (UpdateValueStrategy)new ResetPerspectiveChangeListener());
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.resetPerspective.setLayoutData((Object)data);
    }

    private void createDialogsOption(Composite parent, FormToolkit toolkit) {
        Button noModalDialogs = toolkit.createButton(parent, "Close all modal dialogs", 32);
        IObservableValue noModalDialogsValue = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)ScenarioPackage.eINSTANCE.getWorkbenchContext_NoModalDialogs());
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)noModalDialogs), noModalDialogsValue);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        noModalDialogs.setLayoutData((Object)data);
    }

    private void createClipboardOption(Composite parent, FormToolkit toolkit) {
        Button clearClipboard = toolkit.createButton(parent, "Clear clipboard", 32);
        IObservableValue clearClipboardValue = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)ScenarioPackage.eINSTANCE.getWorkbenchContext_ClearClipboard());
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)clearClipboard), clearClipboardValue);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        clearClipboard.setLayoutData((Object)data);
    }

    public void dispose() {
        super.dispose();
        this.dbc.dispose();
    }

    public void setFocus() {
        this.nameText.setFocus();
    }

    private boolean isPerspectiveSelected() {
        String perspectiveId = this.getContextElement().getPerspectiveId();
        return perspectiveId != null && perspectiveId.trim().length() > 0;
    }

    public NamedElementEditorActions.INamedElementActions createActions() {
        return new CompositeNamedElementActions(new NamedElementEditorActions.INamedElementActions[]{this.editorsTable, this.viewsTable, new TextNamedElementActions(this.perspective)}){

            public void update() {
            }
        };
    }

    private class PerspectiveChangeListener
    extends UpdateValueStrategy<String, String> {
        private PerspectiveChangeListener() {
        }

        public IStatus validateBeforeSet(String value) {
            boolean isPerspectiveSelected;
            String sValue = value;
            boolean bl = isPerspectiveSelected = sValue != null && sValue.trim().length() != 0;
            if (WorkbenchContextEditor.this.resetPerspective != null && !WorkbenchContextEditor.this.resetPerspective.isDisposed()) {
                WorkbenchContextEditor.this.resetPerspective.setEnabled(isPerspectiveSelected);
                if (WorkbenchContextEditor.this.editorsTable != null) {
                    WorkbenchContextEditor.this.editorsTable.setCloseEditorsControlEnabled(!isPerspectiveSelected || !WorkbenchContextEditor.this.resetPerspective.getSelection());
                }
            }
            return super.validateBeforeSet((Object)value);
        }
    }

    private class ResetPerspectiveChangeListener
    extends UpdateValueStrategy<Boolean, Boolean> {
        private ResetPerspectiveChangeListener() {
        }

        public IStatus validateBeforeSet(Boolean value) {
            Boolean sValue = value;
            if (WorkbenchContextEditor.this.editorsTable != null) {
                WorkbenchContextEditor.this.editorsTable.setCloseEditorsControlEnabled(!WorkbenchContextEditor.this.isPerspectiveSelected() || sValue == false);
            }
            return super.validateBeforeSet((Object)value);
        }
    }
}

