/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BlankQuery;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyPropertiesDialog;
import org.eclipse.pde.internal.ui.parts.ConditionalListSelectionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class ImportPackageSection
extends TableSection {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int PROPERTIES_INDEX = 2;
    private ImportPackageHeader fHeader;
    private TableViewer fPackageViewer;
    private Action fAddAction;
    private Action fGoToAction;
    private Action fRemoveAction;
    private Action fPropertiesAction;

    public ImportPackageSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
    }

    private boolean isFragment() {
        IBaseModel iBaseModel = this.getPage().getPDEEditor().getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)iBaseModel;
            return model.isFragmentModel();
        }
        return false;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ImportPackageSection_required);
        if (this.isFragment()) {
            section.setDescription(PDEUIMessages.ImportPackageSection_descFragment);
        } else {
            section.setDescription(PDEUIMessages.ImportPackageSection_desc);
        }
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPackageViewer = tablePart.getTableViewer();
        this.fPackageViewer.setContentProvider((IContentProvider)new ImportPackageContentProvider());
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPackageViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = e1.toString();
                String s2 = e2.toString();
                if (s1.contains(" ")) {
                    s1 = s1.substring(0, s1.indexOf(32));
                }
                if (s2.contains(" ")) {
                    s2 = s2.substring(0, s2.indexOf(32));
                }
                return super.compare(viewer, (Object)s1, (Object)s2);
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        this.fPackageViewer.setInput((Object)model);
        model.addModelChangedListener((IModelChangedListener)this);
        this.updateButtons();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageObject importPackageObject;
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof ImportPackageObject)) {
                return false;
            }
            if (this.fHeader != null && this.fHeader.hasPackage((importPackageObject = (ImportPackageObject)sourceObject).getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IBundleModel model = this.getBundleModel();
        if (model == null) {
            return;
        }
        IBundle bundle = model.getBundle();
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (sourceObject instanceof ImportPackageObject) {
                ImportPackageObject importPackageObject = (ImportPackageObject)sourceObject;
                importPackageObject.reconnect(model, this.fHeader, this.getVersionAttribute());
                if (this.fHeader == null) {
                    bundle.setHeader(this.getImportedPackageHeader(), "");
                } else {
                    this.fHeader.addPackage((PackageObject)importPackageObject);
                }
            }
            ++n2;
        }
    }

    private String getImportedPackageHeader() {
        return "Import-Package";
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        Object[] selected = this.fPackageViewer.getStructuredSelection().toArray();
        int size = selected.length;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && size > 0);
        tablePart.setButtonEnabled(2, this.shouldEnableProperties(selected));
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleGoToPackage((ISelection)selection);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleOpenProperties();
            }
        }
    }

    private IPackageFragment getPackageFragment(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            if (selection.size() != 1) {
                return null;
            }
            IBaseModel model = this.getPage().getModel();
            if (!(model instanceof IPluginModelBase)) {
                return null;
            }
            return PDEJavaHelper.getPackageFragment((String)((PackageObject)selection.getFirstElement()).getName(), (String)((IPluginModelBase)model).getPluginBase().getId(), (IProject)this.getPage().getPDEEditor().getCommonProject());
        }
        return null;
    }

    private void handleGoToPackage(ISelection selection) {
        IPackageFragment frag = this.getPackageFragment(selection);
        if (frag != null) {
            try {
                IViewPart part = PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
                ShowInPackageViewAction action = new ShowInPackageViewAction((IWorkbenchSite)part.getSite());
                action.run((IJavaElement)frag);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    private void handleOpenProperties() {
        Object[] selected = this.fPackageViewer.getStructuredSelection().toArray();
        ImportPackageObject first = (ImportPackageObject)selected[0];
        DependencyPropertiesDialog dialog = new DependencyPropertiesDialog(this.isEditable(), first);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.imported_package_properties");
        SWTUtil.setDialogSize((Dialog)dialog, 400, -1);
        if (selected.length == 1) {
            dialog.setTitle(((ImportPackageObject)selected[0]).getName());
        } else {
            dialog.setTitle(PDEUIMessages.ExportPackageSection_props);
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            boolean newOptional = dialog.isOptional();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                ImportPackageObject object = (ImportPackageObject)selectedObject;
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                if (!newOptional == object.isOptional()) {
                    object.setOptional(newOptional);
                }
                ++n2;
            }
        }
    }

    private void handleRemove() {
        Object[] removed;
        Object[] objectArray = removed = this.fPackageViewer.getStructuredSelection().toArray();
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object removedObject = objectArray[n2];
            this.fHeader.removePackage((PackageObject)removedObject);
            ++n2;
        }
    }

    private void handleAdd() {
        ConditionalListSelectionDialog dialog = new ConditionalListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new ImportPackageDialogLabelProvider(), PDEUIMessages.ImportPackageSection_dialogButtonLabel);
        Runnable runnable = () -> {
            this.setElements(dialog);
            dialog.setMultipleSelection(true);
            dialog.setMessage(PDEUIMessages.ImportPackageSection_exported);
            dialog.setTitle(PDEUIMessages.ImportPackageSection_selection);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.import_packages");
            SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            if (this.fHeader != null) {
                HashSet<String> names = new HashSet<String>();
                int i = 0;
                while (i < selected.length) {
                    ImportPackageObject impObject = null;
                    if (selected[i] instanceof ImportItemWrapper) {
                        selected[i] = ((ImportItemWrapper)selected[i]).fUnderlying;
                    }
                    if (selected[i] instanceof ExportPackageDescription) {
                        impObject = new ImportPackageObject((ManifestHeader)this.fHeader, (ExportPackageDescription)selected[i], this.getVersionAttribute());
                    } else {
                        Object object = selected[i];
                        if (object instanceof IPackageFragment) {
                            IPackageFragment fragment = (IPackageFragment)object;
                            impObject = new ImportPackageObject((ManifestHeader)this.fHeader, fragment.getElementName(), null, this.getVersionAttribute());
                        } else {
                            Object object2 = selected[i];
                            if (object2 instanceof ExportPackageObject) {
                                ExportPackageObject epo = (ExportPackageObject)object2;
                                impObject = new ImportPackageObject((ManifestHeader)this.fHeader, epo.getName(), epo.getVersion(), this.getVersionAttribute());
                            }
                        }
                    }
                    if (impObject != null && names.add(impObject.getName())) {
                        this.fHeader.addPackage((PackageObject)impObject);
                    }
                    ++i;
                }
            } else {
                this.getBundle().setHeader("Import-Package", this.getValue(selected));
            }
        }
    }

    private String getValue(Object[] objects) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ImportItemWrapper) {
                Version version = ((ImportItemWrapper)objects[i]).getVersion();
                if (buffer.length() > 0) {
                    buffer.append("," + this.getLineDelimiter() + " ");
                }
                buffer.append(((ImportItemWrapper)objects[i]).getName());
                if (version != null && !version.equals((Object)Version.emptyVersion)) {
                    buffer.append(";");
                    buffer.append(this.getVersionAttribute());
                    buffer.append("=\"");
                    buffer.append(version.toString());
                    buffer.append("\"");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private void setElements(ConditionalListSelectionDialog dialog) {
        String name;
        Set<String> forbidden = this.getForbiddenIds();
        boolean allowJava = "true".equals(this.getBundle().getHeader("Eclipse-JREBundle"));
        ArrayList<ImportItemWrapper> elements = new ArrayList<ImportItemWrapper>();
        ArrayList<ImportItemWrapper> conditional = new ArrayList<ImportItemWrapper>();
        IPluginModelBase[] models = PluginRegistry.getActiveModels();
        HashSet<NameVersionDescriptor> nameVersions = new HashSet<NameVersionDescriptor>();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
            BundleDescription desc = pluginModel.getBundleDescription();
            if (!this.isFragmentThatCannotExportPackages(pluginModel)) {
                String id;
                String string = id = desc == null ? null : desc.getSymbolicName();
                if (id != null && !forbidden.contains(id)) {
                    ExportPackageHeader header;
                    IBundleModel bmodel;
                    ExportPackageDescription[] exported;
                    ExportPackageDescription[] exportPackageDescriptionArray = exported = desc.getExportPackages();
                    int n3 = exported.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExportPackageDescription exportedPackage = exportPackageDescriptionArray[n4];
                        String name2 = exportedPackage.getName();
                        NameVersionDescriptor nameVersion = new NameVersionDescriptor(exportedPackage.getName(), exportedPackage.getVersion().toString(), "package");
                        if (!(("java".equals(name2) || name2.startsWith("java.")) && !allowJava || !nameVersions.add(nameVersion) || this.fHeader != null && this.fHeader.hasPackage(name2))) {
                            elements.add(new ImportItemWrapper(exportedPackage));
                        }
                        ++n4;
                    }
                    IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
                    if (model instanceof IBundlePluginModelBase && (bmodel = ((IBundlePluginModelBase)model).getBundleModel()) != null && (header = (ExportPackageHeader)bmodel.getBundle().getManifestHeader("Export-Package")) != null) {
                        ExportPackageObject[] pkgs;
                        ExportPackageObject[] exportPackageObjectArray = pkgs = header.getPackages();
                        int n5 = pkgs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String version;
                            ExportPackageObject pkg = exportPackageObjectArray[n6];
                            name = pkg.getName();
                            NameVersionDescriptor nameVersion = new NameVersionDescriptor(name, version = pkg.getVersion(), "package");
                            if (nameVersions.add(nameVersion) && (this.fHeader == null || !this.fHeader.hasPackage(name))) {
                                elements.add(new ImportItemWrapper(pkg));
                            }
                            ++n6;
                        }
                    }
                }
            }
            ++n2;
        }
        iPluginModelBaseArray = models;
        n = models.length;
        n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            try {
                IProject project;
                IResource resource = model.getUnderlyingResource();
                IProject iProject = project = resource != null ? resource.getProject() : null;
                if (project != null && project.hasNature("org.eclipse.jdt.core.javanature") && !WorkspaceModelManager.isBinaryProject((IProject)project) && PDEProject.getManifest((IProject)project).exists() && !this.isFragmentThatCannotExportPackages(model)) {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (roots[j].getKind() == 1 || roots[j].getKind() == 2 && !roots[j].isExternal()) {
                            IJavaElement[] children;
                            IJavaElement[] iJavaElementArray = children = roots[j].getChildren();
                            int n7 = children.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IJavaElement child = iJavaElementArray[n8];
                                IPackageFragment f = (IPackageFragment)child;
                                name = f.getElementName();
                                NameVersionDescriptor nameVersion = new NameVersionDescriptor(name, null, "package");
                                if (name.equals("")) {
                                    name = ".";
                                }
                                if (nameVersions.add(nameVersion) && (f.hasChildren() || f.getNonJavaResources().length > 0)) {
                                    conditional.add(new ImportItemWrapper(f));
                                }
                                ++n8;
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        dialog.setElements(elements.toArray());
        dialog.setConditionalElements(conditional.toArray());
    }

    private boolean isFragmentThatCannotExportPackages(IPluginModelBase fragment) {
        BundleDescription[] hosts;
        if (!fragment.isFragmentModel()) {
            return false;
        }
        BundleDescription bundleDescription = fragment.getBundleDescription();
        if (bundleDescription == null) {
            return false;
        }
        HostSpecification hostSpec = bundleDescription.getHost();
        if (hostSpec == null) {
            return false;
        }
        BundleDescription[] bundleDescriptionArray = hosts = hostSpec.getHosts();
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription host = bundleDescriptionArray[n2];
            if (ClasspathUtilCore.hasExtensibleAPI((IPluginModelBase)PluginRegistry.findModel((Resource)host))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.fHeader = null;
            this.markStale();
            return;
        }
        UIJob job = UIJob.create((String)"Update package imports", monitor -> {
            if ("Import-Package".equals(event.getChangedProperty())) {
                this.refresh();
                Object lastElement = this.fPackageViewer.getElementAt(this.fPackageViewer.getTable().getItemCount() - 1);
                if (lastElement != null) {
                    this.fPackageViewer.setSelection((ISelection)new StructuredSelection(lastElement));
                }
            } else {
                Object[] objects;
                Object[] objectArray = objects = event.getChangedObjects();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object changedObject = objectArray[n2];
                    if (changedObject instanceof ImportPackageObject) {
                        ImportPackageObject object = (ImportPackageObject)changedObject;
                        switch (event.getChangeType()) {
                            case 1: {
                                this.fPackageViewer.remove((Object)object);
                                this.fPackageViewer.add((Object)object);
                                this.fPackageViewer.setSelection((ISelection)new StructuredSelection((Object)object));
                                this.fPackageViewer.getTable().setFocus();
                                break;
                            }
                            case 2: {
                                Table table = this.fPackageViewer.getTable();
                                int index = table.getSelectionIndex();
                                this.fPackageViewer.remove((Object)object);
                                table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                                this.updateButtons();
                                break;
                            }
                            default: {
                                this.fPackageViewer.refresh((Object)object);
                            }
                        }
                    }
                    ++n2;
                }
            }
        });
        job.setSystem(true);
        job.schedule();
    }

    public void refresh() {
        this.fPackageViewer.refresh();
        super.refresh();
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiresSection_add){

            public void run() {
                ImportPackageSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fGoToAction = new Action(PDEUIMessages.ImportPackageSection_goToPackage){

            public void run() {
                ImportPackageSection.this.handleGoToPackage((ISelection)ImportPackageSection.this.fPackageViewer.getStructuredSelection());
            }
        };
        this.fRemoveAction = new Action(PDEUIMessages.RequiresSection_delete){

            public void run() {
                ImportPackageSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fPropertiesAction = new Action(PDEUIMessages.ImportPackageSection_propertyAction){

            public void run() {
                ImportPackageSection.this.handleOpenProperties();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        boolean singleSelection;
        final IStructuredSelection selection = this.fPackageViewer.getStructuredSelection();
        manager.add((IAction)this.fAddAction);
        boolean bl = singleSelection = selection.size() == 1;
        if (singleSelection) {
            manager.add((IAction)this.fGoToAction);
        }
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        if (((IModel)this.getPage().getModel()).getUnderlyingResource() != null) {
            manager.add((IContributionItem)new Separator());
            if (singleSelection) {
                manager.add((IAction)new Action(PDEUIMessages.DependencyExtentSearchResultPage_referencesInPlugin){

                    public void run() {
                        ImportPackageSection.this.doReferenceSearch((ISelection)selection);
                    }
                });
            }
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)this.getPage().getModel(), false));
        }
        if (this.shouldEnableProperties(this.fPackageViewer.getStructuredSelection().toArray())) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fPropertiesAction);
        }
    }

    private void doReferenceSearch(ISelection sel) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = this.getSourceRoots();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        IPackageFragment fragment = this.getPackageFragment(sel);
        if (fragment != null && roots != null) {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet set = manager.createWorkingSet("temp", (IAdaptable[])roots);
            new FindReferencesInWorkingSetAction((IWorkbenchSite)this.getPage().getEditorSite(), new IWorkingSet[]{set}).run((IJavaElement)fragment);
            manager.removeWorkingSet(set);
        } else if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            PackageObject importObject = (PackageObject)selection.getFirstElement();
            NewSearchUI.runQueryInBackground((ISearchQuery)new BlankQuery(importObject));
        }
    }

    private IPackageFragmentRoot[] getSourceRoots() throws JavaModelException {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1 || roots[i].isArchive() && !roots[i].isExternal()) {
                result.add(roots[i]);
            }
            ++i;
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context != null ? context.getModel() : null;
    }

    private String getLineDelimiter() {
        BundleInputContext inputContext = this.getBundleContext();
        if (inputContext != null) {
            return inputContext.getLineDelimiter();
        }
        return TextUtil.getDefaultLineDelimiter();
    }

    private IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model != null ? model.getBundle() : null;
    }

    private String getVersionAttribute() {
        return this.getVersionAttribute(this.getBundle());
    }

    private String getVersionAttribute(IBundle bundle) {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    private Set<String> getForbiddenIds() {
        HashSet<String> set = new HashSet<String>();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        if (model == null) {
            return set;
        }
        String id = model.getPluginBase().getId();
        if (id != null) {
            set.add(id);
        }
        IPluginImport[] imports = model.getPluginBase().getImports();
        State state = TargetPlatformHelper.getState();
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pluginImport = iPluginImportArray[n2];
            this.addDependency(state, pluginImport.getId(), set);
            ++n2;
        }
        return set;
    }

    private void addDependency(State state, String bundleID, Set<String> set) {
        BundleSpecification[] specs;
        BundleDescription[] fragments;
        if (bundleID == null || !set.add(bundleID)) {
            return;
        }
        BundleDescription desc = state.getBundle(bundleID, null);
        if (desc == null) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            this.addDependency(state, fragment.getSymbolicName(), set);
            ++n2;
        }
        BundleSpecification[] bundleSpecificationArray = specs = desc.getRequiredBundles();
        int n3 = specs.length;
        n = 0;
        while (n < n3) {
            BundleSpecification spec = bundleSpecificationArray[n];
            if (spec.isResolved() && spec.isExported()) {
                this.addDependency(state, spec.getName(), set);
            }
            ++n;
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ImportPackageObject)selected[0]).getVersion();
        boolean optional = ((ImportPackageObject)selected[0]).isOptional();
        int i = 1;
        while (i < selected.length) {
            ImportPackageObject object = (ImportPackageObject)selected[i];
            if (version == null ? object.getVersion() != null || optional != object.isOptional() : !version.equals(object.getVersion()) || optional != object.isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static class ImportItemWrapper {
        Object fUnderlying;

        public ImportItemWrapper(Object underlying) {
            this.fUnderlying = underlying;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImportItemWrapper) {
                ImportItemWrapper item = (ImportItemWrapper)obj;
                return this.getName().equals(item.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String getName() {
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getName();
            }
            if (this.fUnderlying instanceof IPackageFragment) {
                return ((IPackageFragment)this.fUnderlying).getElementName();
            }
            if (this.fUnderlying instanceof ExportPackageObject) {
                return ((ExportPackageObject)this.fUnderlying).getName();
            }
            return null;
        }

        public Version getVersion() {
            String version;
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getVersion();
            }
            if (this.fUnderlying instanceof ExportPackageObject && (version = ((ExportPackageObject)this.fUnderlying).getVersion()) != null) {
                return new Version(version);
            }
            return null;
        }

        boolean hasVersion() {
            return this.hasEPD() && ((ExportPackageDescription)this.fUnderlying).getVersion() != null;
        }

        boolean hasEPD() {
            return this.fUnderlying instanceof ExportPackageDescription;
        }
    }

    class ImportPackageContentProvider
    implements IStructuredContentProvider {
        ImportPackageContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (ImportPackageSection.this.fHeader == null) {
                Bundle bundle = (Bundle)ImportPackageSection.this.getBundle();
                ImportPackageSection.this.fHeader = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
            }
            return ImportPackageSection.this.fHeader == null ? new Object[]{} : ImportPackageSection.this.fHeader.getPackages();
        }
    }

    static class ImportPackageDialogLabelProvider
    extends LabelProvider {
        ImportPackageDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }

        public String getText(Object element) {
            StringBuilder buffer = new StringBuilder();
            ImportItemWrapper p = (ImportItemWrapper)element;
            buffer.append(p.getName());
            Version version = p.getVersion();
            if (version != null && !Version.emptyVersion.equals((Object)version)) {
                buffer.append(' ');
                buffer.append(PDELabelProvider.formatVersion(version.toString()));
            }
            return buffer.toString();
        }
    }
}

