/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LowerSPDPackMatrix;
import no.uib.cipr.matrix.LowerTriangPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpperSPDPackMatrix;
import no.uib.cipr.matrix.UpperTriangPackMatrix;

public class PackCholesky {
    private final int n;
    private LowerTriangPackMatrix Cl;
    private UpperTriangPackMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public PackCholesky(int n, boolean upper) {
        this.n = n;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangPackMatrix(n);
        } else {
            this.Cl = new LowerTriangPackMatrix(n);
        }
    }

    public static PackCholesky factorize(Matrix A) {
        return new PackCholesky(A.numRows(), true).factor(new UpperSPDPackMatrix(A));
    }

    public PackCholesky factor(LowerSPDPackMatrix A) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A);
    }

    public PackCholesky factor(UpperSPDPackMatrix A) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A);
    }

    private PackCholesky decompose(AbstractPackMatrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        this.notspd = false;
        int info = 0;
        info = this.upper ? Interface.lapack().pptrf(BLASkernel.UpLo.Upper, A.numRows(), A.getData()) : Interface.lapack().pptrf(BLASkernel.UpLo.Lower, A.numRows(), A.getData());
        if (info > 0) {
            this.notspd = true;
        } else if (info < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A);
        } else {
            this.Cl.set(A);
        }
        return this;
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public LowerTriangPackMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangPackMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (B.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        int info = 0;
        info = this.upper ? Interface.lapack().pptrs(BLASkernel.UpLo.Upper, this.Cu.numRows(), B.numColumns(), this.Cu.getData(), B.getData()) : Interface.lapack().pptrs(BLASkernel.UpLo.Lower, this.Cl.numRows(), B.numColumns(), this.Cl.getData(), B.getData());
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }

    public double rcond(Matrix A) {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] iwork = new int[this.n];
        double[] rcond = new double[1];
        int info = 0;
        info = this.upper ? Interface.lapack().ppcon(BLASkernel.UpLo.Upper, this.n, this.Cu.getData(), anorm, rcond, work, iwork) : Interface.lapack().ppcon(BLASkernel.UpLo.Lower, this.n, this.Cl.getData(), anorm, rcond, work, iwork);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return rcond[0];
    }
}

