/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.MutationDeathType;
import dr.evoxml.util.DataTypeUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ContentRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class MutationDeathTypeParser
extends AbstractXMLObjectParser {
    public static final String MODEL_NAME = "extendedDataType";
    public static final String STATE = "deathState";
    public static final String CODE = "code";
    public static final String STATES = "states";
    public static final String AMBIGUITY = "ambiguity";
    public static final String EXTANT = "extantState";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("dataType", "Base datatype name", DataType.getRegisteredDataTypeNames(), true), new ElementRule(DataType.class, true), new ElementRule("deathState", new XMLSyntaxRule[]{AttributeRule.newStringRule("code")}, true), new ElementRule("extantState", new XMLSyntaxRule[]{AttributeRule.newStringRule("code")}, true), new ContentRule("<ambiguity code=\"Z\" states=\"XY\"/>")};

    @Override
    public String getParserName() {
        return MODEL_NAME;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        MutationDeathType mutationDeathType;
        Logger.getLogger("dr.evolution").info("\nCreating an extended data type.");
        Logger.getLogger("dr.evolution").info("\tIf you publish results using this model, please reference Alekseyenko, Lee and Suchard (in submision).\n");
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        char c = '\u0000';
        XMLObject xMLObject2 = xMLObject.getChild(EXTANT);
        if (xMLObject2 != null) {
            c = xMLObject2.getStringAttribute(CODE).charAt(0);
        }
        char c2 = (xMLObject2 = xMLObject.getChild(STATE)) != null ? xMLObject2.getStringAttribute(CODE).charAt(0) : dataType.getChar(dataType.getGapState());
        Logger.getLogger("dr.evolution").info("\tNon-existent code: " + c2);
        if (dataType == null && c == '\u0000') {
            throw new XMLParseException("In " + xMLObject.getName() + " you must either provide a data type or a code for extant state");
        }
        if (dataType != null) {
            Logger.getLogger("dr.evolution").info("\tBase type: " + dataType.toString());
            mutationDeathType = new MutationDeathType(dataType, c2);
        } else {
            Logger.getLogger("dr.evolution").info("\tExtant code: " + c);
            mutationDeathType = new MutationDeathType(c2, c);
        }
        char c3 = '\u0000';
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (!(object instanceof XMLObject) || !(xMLObject2 = (XMLObject)object).getName().equals(AMBIGUITY)) continue;
            c3 = xMLObject2.getStringAttribute(CODE).charAt(0);
            String string = xMLObject2.hasAttribute(STATES) ? xMLObject2.getStringAttribute(STATES) : "";
            mutationDeathType.addAmbiguity(c3, string);
            Logger.getLogger("dr.evolution").info("\tAmbiguity code: " + c3);
        }
        return mutationDeathType;
    }

    @Override
    public String getParserDescription() {
        return "This element represents an instance of the MutationDeathType which extends a base datatype with an additional \"death\" state.";
    }

    @Override
    public Class getReturnType() {
        return MutationDeathType.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

