/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.tree.Clade;
import dr.evolution.tree.Tree;
import dr.evolution.tree.treemetrics.TreeMetric;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class BranchScoreMetric
implements TreeMetric {
    public static TreeMetric.Type TYPE = TreeMetric.Type.BRANCH_SCORE;
    private Tree focalTree;
    private List<Clade> focalClades;
    private final boolean fixedFocalTree;
    BitSet tmpBits = new BitSet();

    public BranchScoreMetric() {
        this.fixedFocalTree = false;
    }

    public BranchScoreMetric(Tree tree) {
        this.focalTree = tree;
        this.fixedFocalTree = true;
        this.focalClades = Clade.getCladeList(tree);
    }

    @Override
    public double getMetric(Tree tree, Tree tree2) {
        TreeMetric.Utils.checkTreeTaxa(tree, tree2);
        if (tree != this.focalTree) {
            if (this.fixedFocalTree) {
                throw new RuntimeException("Focal tree is different from that set in the constructor.");
            }
            this.focalTree = tree;
            this.focalClades = Clade.getCladeList(this.focalTree);
        }
        List<Clade> list = Clade.getCladeList(tree2);
        return this.getDistance(this.focalClades, list);
    }

    protected double getDistance(List<Clade> list, List<Clade> list2) {
        Collections.sort(list);
        Collections.sort(list2);
        double d = 0.0;
        int n = 0;
        Clade clade = null;
        Clade clade2 = null;
        for (Clade clade3 : list) {
            double d2;
            Clade clade4 = this.findParent(clade3, list);
            double d3 = clade4.getHeight() - clade3.getHeight();
            if (n < list2.size()) {
                clade = list2.get(n);
                clade2 = this.findParent(clade, list2);
            }
            while (clade3.compareTo(clade) > 0 && n < list2.size()) {
                d2 = clade2.getHeight() - clade.getHeight();
                d += d2 * d2;
                if (++n >= list2.size()) continue;
                clade = list2.get(n);
                clade2 = this.findParent(clade, list2);
            }
            if (clade3.compareTo(clade) == 0) {
                d2 = clade2.getHeight() - clade.getHeight();
                d += (d3 - d2) * (d3 - d2);
                ++n;
                continue;
            }
            d += d3 * d3;
        }
        return Math.sqrt(d);
    }

    private Clade findParent(Clade clade, List<Clade> list) {
        Clade clade2 = null;
        for (Clade clade3 : list) {
            if (!this.isParent(clade3, clade) || clade2 != null && clade2.getSize() <= clade3.getSize()) continue;
            clade2 = clade3;
        }
        if (clade2 == null) {
            return clade;
        }
        return clade2;
    }

    private boolean isParent(Clade clade, Clade clade2) {
        if (clade.getSize() <= clade2.getSize()) {
            return false;
        }
        this.tmpBits.clear();
        this.tmpBits.or(clade.getBits());
        this.tmpBits.xor(clade2.getBits());
        return this.tmpBits.cardinality() < clade.getSize();
    }

    @Override
    public TreeMetric.Type getType() {
        return TYPE;
    }

    public String toString() {
        return this.getType().getShortName();
    }
}

