/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRPackageInstaller
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = 3654839767863743685L;
    private static JGRPackageInstaller instance;
    private final JButton install = new JButton("Install");
    private final JButton close = new JButton("Close");
    private final String current = RController.getCurrentPackages();
    private String[] packages = null;
    private JList pkgList;
    private String type = "binaries";

    private JGRPackageInstaller(String[] pkgs, String type) {
        super("Package Installer", false, 154);
        this.type = type;
        this.packages = pkgs;
        String[] Menu = new String[]{"~Window", "0"};
        EzMenuSwing.getEzMenu(this, this, Menu);
        this.close.setActionCommand("close");
        this.close.addActionListener(this);
        this.install.setActionCommand("install");
        this.install.addActionListener(this);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.install);
        buttons.add(this.close);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.pkgList = new JList<String>(this.packages);
        this.getContentPane().add((Component)new JScrollPane(this.pkgList), gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttons, gbc);
        this.pkgList.setCellRenderer(new PkgCellRenderer());
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.close);
        this.setMinimumSize(new Dimension(150, 250));
        this.setLocation(200, 10);
        this.setSize(200, 400);
        this.setResizable(false);
    }

    public static void instAndDisplay(String[] tpkgs, String ttype) {
        final String[] pkgs = tpkgs;
        final String type = ttype;
        Runnable doWork = new Runnable(){

            @Override
            public void run() {
                if (instance == null) {
                    instance = new JGRPackageInstaller(pkgs, type);
                } else {
                    instance.refresh(pkgs, type);
                }
                instance.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public void refresh(String[] pkgs, String type) {
        this.type = type;
        this.packages = pkgs;
        this.pkgList = new JList<String>(this.packages);
        this.pkgList.setCellRenderer(new PkgCellRenderer());
    }

    @Override
    public void dispose() {
        instance = null;
        super.dispose();
    }

    private void installPkg() {
        Object[] instPkgs = this.pkgList.getSelectedValues();
        String cmd = "c(";
        if (instPkgs.length > 0) {
            for (int i = 0; i < instPkgs.length - 1; ++i) {
                cmd = cmd + "\"" + instPkgs[i] + "\",";
            }
            cmd = cmd + "\"" + instPkgs[instPkgs.length - 1] + "\")";
            JGR.MAINRCONSOLE.execute("install.packages(" + cmd + ")", true);
        }
    }

    private boolean checkLibPaths(String path) {
        try {
            String file = path + "/JGR.test";
            if (System.getProperty("os.name").startsWith("Windows")) {
                file = file.replace('/', '\\');
            }
            File f = new File(file);
            f.createNewFile();
            f.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "close" || cmd == "exit") {
            this.dispose();
        } else if (cmd == "install") {
            this.installPkg();
        }
    }

    class PkgCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -8274314191764454898L;

        public PkgCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            if (JGRPackageInstaller.this.current.equals(value.toString())) {
                this.setBackground(isSelected ? Color.blue : Color.lightGray);
                this.setForeground(isSelected ? Color.lightGray : Color.black);
            } else {
                this.setBackground(isSelected ? Color.blue : Color.white);
                this.setForeground(isSelected ? Color.white : Color.black);
            }
            return this;
        }
    }
}

