/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private boolean includesAllowed;
    private String header;

    public PropertiesConfiguration() {
        this.setEncoding(DEFAULT_ENCODING);
        this.setIncludesAllowed(false);
    }

    public PropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public PropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    protected void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean getIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void load(Reader in) throws ConfigurationException {
        reader = new PropertiesReader(in);
        oldAutoSave = this.isAutoSave();
        this.setAutoSave(false);
lbl4:
        // 2 sources

        try {
            try {
                while ((line = reader.readProperty()) != null) {
                    block7: {
                        property = this.parseProperty(line);
                        key = property[0];
                        value = property[1];
                        if (!StringUtils.isNotEmpty(PropertiesConfiguration.getInclude()) || !key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) break block7;
                        if (!this.getIncludesAllowed()) continue;
                        files = StringUtils.split(value, AbstractConfiguration.getDelimiter());
                        i = 0;
                        while (i < files.length) {
                            this.loadIncludeFile(files[i].trim());
                            ++i;
                        }
                        ** GOTO lbl4
                    }
                    this.addProperty(StringEscapeUtils.unescapeJava(key), PropertiesConfiguration.unescapeJava(value, AbstractConfiguration.getDelimiter()));
                }
                var11_11 = null;
                this.setAutoSave(oldAutoSave);
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Could not load configuration from input stream.", ioe);
            }
        }
        catch (Throwable var10_13) {
            var11_12 = null;
            this.setAutoSave(oldAutoSave);
            throw var10_13;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save(Writer writer) throws ConfigurationException {
        this.enterNoReload();
        try {
            try {
                PropertiesWriter out = new PropertiesWriter(writer, AbstractConfiguration.getDelimiter());
                if (this.header != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new StringReader(this.header));
                    while ((line = reader.readLine()) != null) {
                        void var4_5;
                        out.writeComment((String)var4_5);
                    }
                    out.writeln(null);
                }
                out.writeComment("written by PropertiesConfiguration");
                out.writeComment(new Date().toString());
                out.writeln(null);
                Iterator keys = this.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = this.getProperty(key);
                    if (value instanceof List) {
                        out.writeProperty(key, (List)value);
                        continue;
                    }
                    out.writeProperty(key, value);
                }
                out.flush();
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            Object var7_7 = null;
            this.exitNoReload();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.exitNoReload();
            throw throwable;
        }
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty(basePath));
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() == 4) {
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.append((char)value);
                        unicode.setLength(0);
                        inUnicode = false;
                        hadSlash = false;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                    }
                }
            } else if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                } else if (ch == '\'') {
                    out.append('\'');
                } else if (ch == '\"') {
                    out.append('\"');
                } else if (ch == 'r') {
                    out.append('\r');
                } else if (ch == 'f') {
                    out.append('\f');
                } else if (ch == 't') {
                    out.append('\t');
                } else if (ch == 'n') {
                    out.append('\n');
                } else if (ch == 'b') {
                    out.append('\b');
                } else if (ch == delimiter) {
                    out.append('\\');
                    out.append(delimiter);
                } else if (ch == 'u') {
                    inUnicode = true;
                } else {
                    out.append(ch);
                }
            } else if (ch == '\\') {
                hadSlash = true;
            } else {
                out.append(ch);
            }
            ++i;
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    private String[] parseProperty(String line) {
        String[] result = new String[2];
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int state = 0;
        int pos = 0;
        while (pos < line.length()) {
            char c = line.charAt(pos);
            switch (state) {
                case 0: {
                    if (c == '\\') {
                        state = 1;
                        break;
                    }
                    if (ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                        state = 2;
                        break;
                    }
                    if (ArrayUtils.contains((char[])SEPARATORS, (char)c)) {
                        state = 3;
                        break;
                    }
                    key.append(c);
                    break;
                }
                case 1: {
                    if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                        key.append(c);
                    } else {
                        key.append('\\');
                        key.append(c);
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                        state = 2;
                        break;
                    }
                    if (ArrayUtils.contains((char[])SEPARATORS, (char)c)) {
                        state = 3;
                        break;
                    }
                    value.append(c);
                    state = 3;
                    break;
                }
                case 3: {
                    value.append(c);
                }
            }
            ++pos;
        }
        result[0] = key.toString().trim();
        result[1] = value.toString().trim();
        return result;
    }

    private void loadIncludeFile(String fileName) throws ConfigurationException {
        URL baseURL;
        URL url = ConfigurationUtils.locate(this.getBasePath(), fileName);
        if (url == null && (baseURL = this.getURL()) != null) {
            url = ConfigurationUtils.locate(baseURL.toString(), fileName);
        }
        if (url == null) {
            throw new ConfigurationException("Cannot resolve include file " + fileName);
        }
        this.load(url);
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private char delimiter;

        public PropertiesWriter(Writer writer, char delimiter) {
            super(writer);
            this.delimiter = delimiter;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.write(this.escapeKey(key));
            this.write(" = ");
            if (value != null) {
                String v = StringEscapeUtils.escapeJava(String.valueOf(value));
                v = StringUtils.replace(v, String.valueOf(this.delimiter), "\\" + this.delimiter);
                this.write(v);
            }
            this.writeln(null);
        }

        public void writeProperty(String key, List values) throws IOException {
            int i = 0;
            while (i < values.size()) {
                this.writeProperty(key, values.get(i));
                ++i;
            }
        }

        public void writeComment(String comment) throws IOException {
            this.writeln("# " + comment);
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            int i = 0;
            while (i < key.length()) {
                char c = key.charAt(i);
                if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                    newkey.append('\\');
                    newkey.append(c);
                } else {
                    newkey.append(c);
                }
                ++i;
            }
            return newkey.toString();
        }

        private void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (StringUtils.isEmpty(line = line.trim()) || line.charAt(0) == '#' || line.charAt(0) == '!') continue;
                if (!PropertiesReader.checkCombineLines(line)) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            int idx = line.length() - 1;
            while (idx >= 0 && line.charAt(idx) == '\\') {
                ++bsCount;
                --idx;
            }
            return bsCount % 2 == 1;
        }
    }
}

