/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.jclec.JCLEC;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import net.sourceforge.jclec.util.random.IRandGen;

public class SyntaxTreeSchema
implements JCLEC {
    private static final long serialVersionUID = -8873594607721603028L;
    protected TerminalNode[] terminals;
    protected NonTerminalNode[] nonTerminals;
    protected String rootSymbol;
    protected int maxDerivSize;
    protected int minDerivSize;
    protected transient HashMap<String, TerminalNode> terminalsMap;
    protected transient HashMap<String, NonTerminalNode[]> nonTerminalsMap;
    protected transient HashMap<String[], Long[]> cardinalityMap;

    public void setMaxDerivSize(int maxDerivSize) {
        this.maxDerivSize = maxDerivSize;
        if (this.terminalsMap != null && this.nonTerminalsMap != null) {
            this.setCardinalityMap();
        }
    }

    public void setTerminals(TerminalNode[] terminals) {
        this.terminals = terminals;
        this.setTerminalsMap();
        if (this.maxDerivSize != 0 && this.nonTerminalsMap != null) {
            this.setCardinalityMap();
        }
    }

    public void setNonTerminals(NonTerminalNode[] nonTerminals) {
        this.nonTerminals = nonTerminals;
        this.setNonTerminalsMap();
        if (this.maxDerivSize != 0 && this.terminalsMap != null) {
            this.setCardinalityMap();
        }
    }

    public void setRootSymbol(String rootSymbol) {
        this.rootSymbol = rootSymbol;
    }

    public int getMaxDerivSize() {
        return this.maxDerivSize;
    }

    public String getRootSymbol() {
        return this.rootSymbol;
    }

    public int getMinDerivSize() {
        if (this.minDerivSize == 0) {
            this.setMinDerivSize();
        }
        return this.minDerivSize;
    }

    public TerminalNode[] getTerminals() {
        return this.terminals;
    }

    public NonTerminalNode[] getNonTerminals() {
        return this.nonTerminals;
    }

    public boolean isTerminal(String symbol) {
        return this.terminalsMap.containsKey(symbol);
    }

    public SyntaxTree createSyntaxTree(int nOfDer, IRandGen randgen) {
        SyntaxTree result = new SyntaxTree();
        this.fillSyntaxBranch(result, this.rootSymbol, nOfDer, randgen);
        return result;
    }

    public void fillSyntaxBranch(SyntaxTree owner, String symbol, IRandGen randgen) {
        int i = 0;
        while (i < this.maxDerivSize) {
            if (this.cardinality(symbol, i) != 0L) {
                this.fillSyntaxBranch(owner, symbol, i, randgen);
            }
            ++i;
        }
    }

    public void fillSyntaxBranch(SyntaxTree owner, String symbol, int nOfDer, IRandGen randgen) {
        if (this.isTerminal(symbol)) {
            owner.addNode(this.getTerminal(symbol));
        } else {
            NonTerminalNode selectedProduction = this.selectProduction(symbol, nOfDer, randgen);
            if (selectedProduction != null) {
                owner.addNode(selectedProduction);
                int[] selectedPartition = this.selectPartition(selectedProduction.production, nOfDer - 1, randgen);
                int selProdSize = selectedPartition.length;
                int i = 0;
                while (i < selProdSize) {
                    this.fillSyntaxBranch(owner, selectedProduction.production[i], selectedPartition[i], randgen);
                    ++i;
                }
            } else {
                this.fillSyntaxBranch(owner, symbol, nOfDer - 1, randgen);
            }
        }
    }

    protected final void setMinDerivSize() {
        int i = 0;
        while (i < this.maxDerivSize) {
            if (this.cardinality(this.rootSymbol, i) != 0L) {
                this.minDerivSize = i;
                return;
            }
            ++i;
        }
    }

    protected final void setTerminalsMap() {
        this.terminalsMap = new HashMap();
        TerminalNode[] terminalNodeArray = this.terminals;
        int n = this.terminals.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalNode termSymbol = terminalNodeArray[n2];
            this.terminalsMap.put(termSymbol.getSymbol(), termSymbol);
            ++n2;
        }
    }

    protected final void setNonTerminalsMap() {
        HashMap auxMap = new HashMap();
        NonTerminalNode[] nonTerminalNodeArray = this.nonTerminals;
        int n = this.nonTerminals.length;
        int n2 = 0;
        while (n2 < n) {
            NonTerminalNode nonTermSymbol = nonTerminalNodeArray[n2];
            String nonTermSymbolName = nonTermSymbol.getSymbol();
            if (auxMap.containsKey(nonTermSymbolName)) {
                ((List)auxMap.get(nonTermSymbolName)).add(nonTermSymbol);
            } else {
                ArrayList<NonTerminalNode> list = new ArrayList<NonTerminalNode>();
                list.add(nonTermSymbol);
                auxMap.put(nonTermSymbolName, list);
            }
            ++n2;
        }
        this.nonTerminalsMap = new HashMap();
        for (String nonTermName : auxMap.keySet()) {
            List list = (List)auxMap.get(nonTermName);
            NonTerminalNode[] array = list.toArray(new NonTerminalNode[list.size()]);
            this.nonTerminalsMap.put(nonTermName, array);
        }
    }

    protected final void setCardinalityMap() {
        this.cardinalityMap = new HashMap();
        NonTerminalNode[] nonTerminalNodeArray = this.nonTerminals;
        int n = this.nonTerminals.length;
        int n2 = 0;
        while (n2 < n) {
            NonTerminalNode nonTermSymbol = nonTerminalNodeArray[n2];
            Long[] list1 = new Long[1 + this.maxDerivSize];
            int j = 0;
            while (j < list1.length) {
                list1[j] = -1L;
                ++j;
            }
            this.cardinalityMap.put(nonTermSymbol.production, list1);
            ++n2;
        }
    }

    public final TerminalNode getTerminal(String symbol) {
        return this.terminalsMap.get(symbol);
    }

    protected NonTerminalNode selectProduction(String symbol, int nOfDer, IRandGen randgen) {
        NonTerminalNode[] prodRules = this.nonTerminalsMap.get(symbol);
        int nOfProdRules = prodRules.length;
        long[] roulette = new long[nOfProdRules];
        int i = 0;
        while (i < nOfProdRules) {
            Long[] cardinalities = this.cardinalityMap.get(prodRules[i].production);
            if (cardinalities[nOfDer - 1] == -1L) {
                cardinalities[nOfDer - 1] = this.cardinality(prodRules[i].production, nOfDer - 1);
                this.cardinalityMap.put(prodRules[i].production, cardinalities);
            }
            roulette[i] = cardinalities[nOfDer - 1];
            if (i != 0) {
                int n = i;
                roulette[n] = roulette[n] + roulette[i - 1];
            }
            ++i;
        }
        long randVal = (long)((double)roulette[nOfProdRules - 1] * randgen.raw());
        int i2 = 0;
        while (i2 < nOfProdRules) {
            if (randVal < roulette[i2]) {
                return prodRules[i2];
            }
            ++i2;
        }
        return null;
    }

    protected final int[] selectPartition(String[] prodRule, int nOfDer, IRandGen randgen) {
        List<int[]> partitions = this.partitions(nOfDer, prodRule.length);
        int nOfPart = partitions.size();
        long[] roulette = new long[nOfPart];
        int i = 0;
        while (i < nOfPart) {
            roulette[i] = this.cardinality(prodRule, partitions.get(i));
            if (i != 0) {
                int n = i;
                roulette[n] = roulette[n] + roulette[i - 1];
            }
            ++i;
        }
        long randVal = (long)((double)roulette[nOfPart - 1] * randgen.raw());
        int i2 = 0;
        while (i2 < nOfPart) {
            if (randVal < roulette[i2]) {
                return partitions.get(i2);
            }
            ++i2;
        }
        return null;
    }

    protected final long cardinality(String symbol, int nOfDer) {
        NonTerminalNode[] prodRules;
        if (this.isTerminal(symbol)) {
            return nOfDer == 0 ? 1L : 0L;
        }
        long result = 0L;
        NonTerminalNode[] nonTerminalNodeArray = prodRules = this.nonTerminalsMap.get(symbol);
        int n = prodRules.length;
        int n2 = 0;
        while (n2 < n) {
            NonTerminalNode prodRule = nonTerminalNodeArray[n2];
            Long[] cardinalities = this.cardinalityMap.get(prodRule.production);
            if (nOfDer <= 0) {
                result += this.cardinality(prodRule.production, nOfDer - 1);
            } else {
                if (cardinalities[nOfDer - 1] == -1L) {
                    cardinalities[nOfDer - 1] = this.cardinality(prodRule.production, nOfDer - 1);
                    this.cardinalityMap.put(prodRule.production, cardinalities);
                }
                result += cardinalities[nOfDer - 1].longValue();
            }
            ++n2;
        }
        return result;
    }

    protected final long cardinality(String[] pRule, int nOfDer) {
        long result = 0L;
        List<int[]> partitions = this.partitions(nOfDer, pRule.length);
        for (int[] partition : partitions) {
            result += this.cardinality(pRule, partition);
        }
        return result;
    }

    protected final long cardinality(String[] prodRule, int[] partition) {
        int prodRuleSize = prodRule.length;
        long result = 1L;
        int i = 0;
        while (i < prodRuleSize) {
            long factor = this.cardinality(prodRule[i], partition[i]);
            if (factor == 0L) {
                return 0L;
            }
            result *= factor;
            ++i;
        }
        return result;
    }

    protected final List<int[]> partitions(int total, int dimension) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        if (dimension == 1) {
            result.add(new int[]{total});
        } else {
            int i = 0;
            while (i <= total) {
                List<int[]> pi = this.partitions(total - i, dimension - 1);
                result.addAll(this.insertBefore(i, pi));
                ++i;
            }
        }
        return result;
    }

    protected final List<int[]> insertBefore(int previous, List<int[]> strings) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int[] string : strings) {
            int[] tmp = new int[1 + string.length];
            System.arraycopy(string, 0, tmp, 1, string.length);
            tmp[0] = previous;
            result.add(tmp);
        }
        return result;
    }
}

