/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.SVM.SMO.core.Instance;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.core.Option;
import keel.Algorithms.SVM.SMO.core.Utils;
import keel.Algorithms.SVM.SMO.supportVector.CachedKernel;

public class PDRFKernel
extends CachedKernel {
    public static int SymmetricTriangle = 1;
    public static int Gaussian = 2;
    public static int Cauchy = 3;
    public static int Laplace = 4;
    public static int HyperbolicSecant = 5;
    public static int SquaredSinc = 6;
    static final long serialVersionUID = 7672176272736783265L;
    protected double[] m_kernelPrecalc;
    protected double m_d = 0.01;
    protected int m_type = SymmetricTriangle;

    public PDRFKernel() {
    }

    public PDRFKernel(Instances data, int cacheSize, double gamma) throws Exception {
        this.setCacheSize(cacheSize);
        this.setD(gamma);
        this.buildKernel(data);
    }

    @Override
    public String globalInfo() {
        return "The PRDF kernel. K(x, y) = K(u) = Productory_{k=1}^n a^k(u_k)";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe d parameter.\n\t(default: 1)", "D", 1, "-D <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('D', options);
        if (tmpStr.length() != 0) {
            this.setD(Double.parseDouble(tmpStr));
        } else {
            this.setD(0.01);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-D");
        result.add("" + this.getD());
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        int i;
        if (id1 == id2) {
            return 1.0;
        }
        Instance inst2 = this.m_data.instance(id2);
        double[] u = new double[inst2.numAttributes() - 1];
        if (id1 == -1) {
            int j = 0;
            for (i = 0; i < inst1.numAttributes(); ++i) {
                if (i == inst1.classIndex()) continue;
                u[j] = inst1.value(i) - inst2.value(i);
                ++j;
            }
        } else {
            int j = 0;
            for (i = 0; i < inst1.numAttributes(); ++i) {
                if (i == inst1.classIndex()) continue;
                u[j] = this.m_data.instance(id1).value(i) - inst2.value(i);
                ++j;
            }
        }
        double result = this.evaluatePRDF(u);
        return result;
    }

    public void setD(double value) {
        this.m_d = value;
    }

    public double getD() {
        return this.m_d;
    }

    public void setPDRFType(int type) {
        this.m_type = type;
    }

    public String dTipText() {
        return "The d value.";
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        this.m_kernelPrecalc = new double[data.numInstances()];
    }

    public String toString() {
        return "PRDF kernel: K(x,y) = Productory_{k=1}^n a^k (x-y)_k";
    }

    public double evaluatePRDF(double[] u) {
        double prod = 1.0;
        for (int i = 0; i < u.length; ++i) {
            if (this.m_type == SymmetricTriangle) {
                prod *= this.symmetricTriangle(u[i]);
                continue;
            }
            if (this.m_type == Gaussian) {
                prod *= this.gaussian(u[i]);
                continue;
            }
            if (this.m_type == Cauchy) {
                prod *= this.cauchy(u[i]);
                continue;
            }
            if (this.m_type == Laplace) {
                prod *= this.laplace(u[i]);
                continue;
            }
            if (this.m_type == HyperbolicSecant) {
                prod *= this.hyperbolicSecant(u[i]);
                continue;
            }
            if (this.m_type != SquaredSinc) continue;
            prod *= this.squaredSinc(u[i]);
        }
        return prod;
    }

    public double symmetricTriangle(double x) {
        return Math.max(0.0, 1.0 - this.m_d * Math.abs(x));
    }

    public double gaussian(double x) {
        return Math.exp(-this.m_d * Math.pow(x, 2.0));
    }

    public double cauchy(double x) {
        return 1.0 / (1.0 + this.m_d * Math.pow(x, 2.0));
    }

    public double laplace(double x) {
        return Math.exp(-this.m_d * Math.abs(x));
    }

    public double hyperbolicSecant(double x) {
        return 2.0 / (Math.exp(this.m_d * x) + Math.exp(-this.m_d * x));
    }

    public double squaredSinc(double x) {
        return Math.pow(Math.sin(this.m_d * x), 2.0) / Math.pow(this.m_d, 2.0) * Math.pow(x, 2.0);
    }
}

