/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.JointGradient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelGradientExecutor {
    private final ExecutorService pool;
    private final List<DerivativeCaller> derivativeCaller;
    public static final boolean DEBUG_PARALLEL_EVALUATION = false;

    public ParallelGradientExecutor(int threads, List<GradientWrtParameterProvider> derivativeList) {
        assert (derivativeList.size() > 1);
        if (threads <= 0) {
            this.pool = Executors.newCachedThreadPool();
        } else {
            int threadCount = Math.min(threads, derivativeList.size());
            this.pool = Executors.newFixedThreadPool(threadCount);
        }
        this.derivativeCaller = new ArrayList<DerivativeCaller>(derivativeList.size());
        int i = 0;
        while (i < derivativeList.size()) {
            this.derivativeCaller.add(new DerivativeCaller(derivativeList.get(i), i));
            ++i;
        }
    }

    public double[] getDerivativeLogDensityInParallel(JointGradient.DerivativeType derivativeType, Reducer reducer, int length) {
        for (DerivativeCaller caller : this.derivativeCaller) {
            caller.setDerivativeType(derivativeType);
        }
        double[] derivative = null;
        try {
            List<Future<double[]>> results = this.pool.invokeAll(this.derivativeCaller);
            derivative = reducer.reduce(results, length);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        return derivative;
    }

    private static class DerivativeCaller
    implements Callable<double[]> {
        private final GradientWrtParameterProvider gradient;
        private final int index;
        private JointGradient.DerivativeType type;

        public DerivativeCaller(GradientWrtParameterProvider gradient, int index) {
            this.gradient = gradient;
            this.index = index;
        }

        @Override
        public double[] call() throws Exception {
            return this.type.getDerivativeLogDensity(this.gradient);
        }

        public void setDerivativeType(JointGradient.DerivativeType type) {
            this.type = type;
        }
    }

    static interface Reducer {
        public double[] reduce(List<Future<double[]>> var1, int var2) throws ExecutionException, InterruptedException;
    }
}

