package PROP::ResultSet::LinkTest;

use strict;
use base qw/Test::Unit::TestCase/;
use PROP::DBH;
use PROP::TestCommon;
use PROP::Util;
use PROP::Link;
use PROP::Query::Link;
use PROP::ResultSet::Link;
use Data::Dumper;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    drop_tables();
    create_tables();
}

sub tear_down {
    my ($self) = @_;

    drop_tables();
}

sub test_stuff {
    my ($self) = @_;

    my ($f, $b, $fz, $links) = populate_database();

    # NEW

    my $fc = new PROP::Conditions::Foreign($links->[0], 'children');

    my $query = new PROP::Query::Link($fc);
#    my $query = new PROP::Query::Link($links->[0], 'children');

    my $result_set = $query->execute();

    my $result;
    my $i = 0;

    while($result = $result_set->get_next_result()) {
	$self->assert_equals($f->[$i]->get_pk_value(), $result->get_pk_value());
	$self->assert_equals(4, scalar(@{$result->get_relatives()}));

	for(my $j = 0; $j < scalar(@{$result->get_relatives()}); ++$j) {
	    $self->assert_equals($b->[$j]->get_pk_value(),
				 $result->get_relatives()->[$j]->get_pk_value());

	    $self->assert_equals($i + 1, $result->get_relatives()->[$j]->get_contextual_value('foo_id'));

	    $self->assert_equals($i, $result->get_relatives()->[$j]->get_contextual_value('c1'));
	    $self->assert_equals($i * $j, $result->get_relatives()->[$j]->get_contextual_value('c2'));
	    $self->assert_equals('meh', $result->get_relatives()->[$j]->get_contextual_value('c3'));
	}

	++$i;
    }
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
