package PROP::Conf::MySQLTest;

use strict;
use base qw/Test::Unit::TestCase/;
use IO::Pipe;
use PROP::Conf::MySQL;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    my $reader = new IO::Handle;
    my $writer = new IO::Handle;

    pipe($reader, $writer);

    $self->set_read_handle($reader);
    $self->set_write_handle($writer);

    $self->fill_pipe();

    close($writer);
}

sub tear_down {
    my ($self) = @_;
    close($self->get_read_handle());
}

sub get_read_handle {
    my ($self) = @_;
    return $self->{-read_handle};
}

sub set_read_handle {
    my ($self, $read_handle) = @_;
    $self->{-read_handle} = $read_handle;
}

sub get_write_handle {
    my ($self) = @_;
    return $self->{-write_handle};
}

sub set_write_handle {
    my ($self, $write_handle) = @_;
    $self->{-write_handle} = $write_handle;
}

sub fill_pipe {
    my ($self) = @_;

    my $writer = $self->get_write_handle();


    print $writer "[mysqld]\n";
    print $writer "datadir=/var/lib/mysql\n";
    print $writer "socket=/var/lib/mysql/mysql.sock\n";

    print $writer "[client]\n";
    print $writer "user = jsmith\n";
    print $writer "password = f00b4r\n";
    print $writer "host = localhost\n";
    print $writer "port = 3306\n";
    print $writer "database = test\n";
     
    print $writer "[mysql.server]\n";
    print $writer "user=mysql\n";
    print $writer "basedir=/var/lib\n";

    print $writer "[safe_mysqld]\n";
    print $writer "err-log=/var/log/mysqld.log\n";
    print $writer "pid-file=/var/run/mysqld/mysqld.pid\n";

}

sub test_params {
    my ($self) = @_;
    my $reader = $self->get_read_handle();
    my $conf = new PROP::Conf('MySQL', $reader);

    $self->assert_equals('jsmith', $conf->get_user());
    $self->assert_equals('f00b4r', $conf->get_password());
    $self->assert_equals('localhost', $conf->get_host());
    $self->assert_equals(3306, $conf->get_port());
    $self->assert_equals('test', $conf->get_database());
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
