/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SeqTrunc {
    public static void main(String[] args) throws IOException {
        Object seq;
        if (args.length != 2) {
            System.err.println("USAGE: SeqTrunc <in_file> <trunc_len>");
            System.exit(1);
        }
        File seqFile = new File(args[0]);
        int truncLen = Integer.parseInt(args[1]);
        FastaWriter out = new FastaWriter(new BufferedOutputStream(new FileOutputStream("trunc_seqs.fasta")));
        int[] lengthHisto = new int[255];
        SequenceReader reader = new SequenceReader(seqFile);
        while ((seq = reader.readNextSequence()) != null) {
            String seqString = ((Sequence)seq).getSeqString();
            int seqLength = seqString.length();
            if (seqLength > truncLen) {
                seqString = seqString.substring(0, truncLen);
            }
            int n = seqLength;
            lengthHisto[n] = lengthHisto[n] + 1;
            out.writeSeq(((Sequence)seq).getSeqName(), ((Sequence)seq).getDesc(), seqString);
        }
        out.close();
        int count = 0;
        int tot = 0;
        for (int index = 0; index < lengthHisto.length; ++index) {
            tot += lengthHisto[index] * index;
            count += lengthHisto[index];
            if (lengthHisto[index] <= 0) continue;
            System.err.println(index + "\t" + lengthHisto[index]);
        }
        System.err.println("Total sequences: " + count + ", average length: " + (float)tot / (float)count);
    }
}

