/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.AbstractNode;
import edu.msu.cme.rdp.classifier.comparison.ComparisonBrowserNode;
import edu.msu.cme.rdp.classifier.comparison.Score;
import edu.msu.cme.rdp.classifier.comparison.SigCalculator;
import edu.msu.cme.rdp.classifier.comparison.TaxonTree;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UncNode
extends AbstractNode {
    UncNode(AbstractNode p) {
        this.setParent(p);
    }

    @Override
    AbstractNode getFirstChild() {
        return null;
    }

    @Override
    public String getName() {
        return "unclassified " + this.getParent().getName();
    }

    @Override
    public String getRank() {
        return "";
    }

    @Override
    public int getTaxid() {
        return 0 - this.getParent().getTaxid();
    }

    @Override
    public ComparisonBrowserNode findNode(int id) {
        if (this.getTaxid() == id) {
            return this;
        }
        ComparisonBrowserNode node = this.getNextSibling();
        if (node != null) {
            node = node.findNode(id);
        }
        return node;
    }

    @Override
    public void changeConfidence(SigCalculator cal) {
        AbstractNode sibling;
        this.resetCount();
        if (sibling == null) {
            return;
        }
        int parentS1Count = this.getParent().getS1Count();
        int parentS2Count = this.getParent().getS2Count();
        int childS1Count = 0;
        int childS2Count = 0;
        for (sibling = this.getParent().getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            childS1Count += sibling.getS1Count();
            childS2Count += sibling.getS2Count();
        }
        this.incS1Count(parentS1Count - childS1Count);
        this.incS2Count(parentS2Count - childS2Count);
        this.setSignificance(cal.calculateSig(this.getS1Count(), this.getS2Count()));
    }

    @Override
    public Iterator getDetailIterator(float conf) {
        DetailIterator it = new DetailIterator(conf);
        return it;
    }

    class SampleDetailIterator
    implements Iterator {
        private Object onDeck;
        private Score curScore;
        private float confCutoff;

        public SampleDetailIterator(Score s, float conf) {
            Score score = s;
            this.confCutoff = conf;
            this.setNextElement(score);
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        public Object next() {
            if (this.onDeck == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.onDeck;
            Score score = this.curScore.getNextSeqScore();
            this.setNextElement(score);
            return tmp;
        }

        private void setNextElement(Score score) {
            Score nextAssignScore;
            while (!(score == null || score.getScore() >= this.confCutoff && (nextAssignScore = score.getNextAssignScore()) != null && nextAssignScore.getScore() < this.confCutoff)) {
                score = score.getNextSeqScore();
            }
            if (score != null) {
                this.onDeck = score.getSeqInfo();
                this.curScore = score;
            } else {
                this.onDeck = null;
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }

    class DetailIterator
    implements Iterator {
        private Object onDeck;
        private Iterator s1DetailIterator;
        private Iterator s2DetailIterator;

        public DetailIterator(float conf) {
            Score s1Score = ((TaxonTree)UncNode.this.getParent()).getFirstS1Score();
            Score s2Score = ((TaxonTree)UncNode.this.getParent()).getFirstS2Score();
            this.s1DetailIterator = new SampleDetailIterator(s1Score, conf);
            this.s2DetailIterator = new SampleDetailIterator(s2Score, conf);
            this.setNextElement(this.s1DetailIterator, this.s2DetailIterator);
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        public Object next() {
            if (this.onDeck == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.onDeck;
            this.setNextElement(this.s1DetailIterator, this.s2DetailIterator);
            return tmp;
        }

        private void setNextElement(Iterator s1, Iterator s2) {
            this.onDeck = s1.hasNext() ? s1.next() : (s2.hasNext() ? s2.next() : null);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }
}

