/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class OrderNSymbolList
extends AbstractSymbolList
implements Serializable {
    private final SymbolList source;
    private final Alphabet alpha;
    private final int order;

    public OrderNSymbolList(SymbolList symbolList, int n) throws IllegalAlphabetException {
        this.source = symbolList;
        Alphabet alphabet = symbolList.getAlphabet();
        this.alpha = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(n, alphabet));
        this.order = n;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public SymbolList getSource() {
        return this.source;
    }

    public int length() {
        return this.source.length() - this.order + 1;
    }

    public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
        if (n < 1 || n > this.length()) {
            throw new IndexOutOfBoundsException("index must be within (1 .. " + this.length() + "), not " + n);
        }
        try {
            Symbol[] symbolArray = new Symbol[this.order];
            int n2 = 0;
            while (n2 < this.order) {
                symbolArray[n2] = this.source.symbolAt(n + n2);
                ++n2;
            }
            return this.alpha.getSymbol(Arrays.asList(symbolArray));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Alphabet changed underneath me");
        }
    }
}

