/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DomainException;

public class Quadratic {
    private static final double TWO_PI = Math.PI * 2;
    private static final double FOUR_PI = Math.PI * 4;
    public int nRoots;
    public double x1;
    public double x2;

    public void solve(double d, double d2, double d3) {
        if (d == 0.0) {
            throw new DomainException("Quadratic.solve(): a = 0");
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (d4 >= 0.0) {
            this.nRoots = 2;
            double d5 = -0.5 * (d2 + Quadratic.sgn(d2) * Math.sqrt(d4));
            this.x1 = d5 / d;
            this.x2 = d3 / d5;
            this.sortRoots();
        } else {
            this.nRoots = 0;
            this.x1 = Double.NaN;
            this.x2 = Double.NaN;
        }
    }

    private static double sgn(double d) {
        return d < 0.0 ? -1.0 : 1.0;
    }

    private void sortRoots() {
        if (this.x1 < this.x2) {
            double d = this.x1;
            this.x1 = this.x2;
            this.x2 = d;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            Quadratic.usage();
        }
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        double d3 = Double.parseDouble(stringArray[2]);
        Quadratic quadratic = new Quadratic();
        quadratic.solve(d, d2, d3);
        if (quadratic.nRoots == 2) {
            System.out.println("x1 = " + quadratic.x1);
            System.out.println("x2 = " + quadratic.x2);
        } else {
            System.out.println("No real roots");
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.numeric.Quadratic <a> <b> <c>");
        System.err.println("Solves ax^2 + bx + c = 0");
        System.exit(1);
    }
}

