/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Channel;
import edu.rit.mp.IORequest;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;

class IORequestList {
    LinkedList<IORequest> myList = new LinkedList();

    public synchronized void add(IORequest iORequest) {
        this.myList.add(iORequest);
        this.notifyAll();
    }

    public synchronized IORequest removeMatch(IORequest iORequest) {
        Iterator iterator = this.myList.iterator();
        while (iterator.hasNext()) {
            IORequest iORequest2 = (IORequest)iterator.next();
            if (!iORequest2.match(iORequest)) continue;
            iterator.remove();
            return iORequest2;
        }
        return null;
    }

    public synchronized IORequest removeMatch(Channel channel, Integer n, byte by) {
        Iterator iterator = this.myList.iterator();
        while (iterator.hasNext()) {
            IORequest iORequest = (IORequest)iterator.next();
            if (!iORequest.match(channel, n, by)) continue;
            iterator.remove();
            return iORequest;
        }
        return null;
    }

    public synchronized IORequest waitForMatch(IORequest iORequest) throws InterruptedException {
        IORequest iORequest2;
        while ((iORequest2 = this.removeMatch(iORequest)) == null) {
            this.wait();
        }
        return iORequest2;
    }

    public synchronized IORequest waitForMatch(Channel channel, Integer n, byte by) throws InterruptedException {
        IORequest iORequest;
        while ((iORequest = this.removeMatch(channel, n, by)) == null) {
            this.wait();
        }
        return iORequest;
    }

    public synchronized void reportFailure(IOException iOException) {
        IORequest iORequest = null;
        while (!this.myList.isEmpty()) {
            iORequest = this.myList.remove(0);
            iORequest.reportFailure(iOException);
        }
    }

    public synchronized void dump(PrintStream printStream, String string) {
        printStream.println(string + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        printStream.println(string + "\t" + this.myList.size() + " entries");
        for (IORequest iORequest : this.myList) {
            printStream.println(string + "\t" + iORequest);
        }
    }
}

