/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.network;

import edu.rit.io.DoubleMatrixFile;
import edu.rit.io.Files;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydClu {
    static Comm world;
    static int size;
    static int rank;
    static int n;
    static double[][] d;
    static double[] row_i;
    static DoubleBuf row_i_buf;

    private FloydClu() {
    }

    public static void main(String[] stringArray) throws Throwable {
        Object object;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            FloydClu.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        DoubleMatrixFile.Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(file)));
        d = doubleMatrixFile.getMatrix();
        n = d.length;
        Range[] rangeArray = new Range(0, n - 1).subranges(size);
        Range range = rangeArray[rank];
        int n = range.lb();
        int n2 = range.ub();
        reader.readRowSlice(range);
        reader.close();
        row_i = new double[FloydClu.n];
        row_i_buf = DoubleBuf.buffer(row_i);
        long l2 = System.currentTimeMillis();
        int n3 = 0;
        for (int i = 0; i < FloydClu.n; ++i) {
            double[] dArray = d[i];
            if (!rangeArray[n3].contains(i)) {
                ++n3;
            }
            if (rank == n3) {
                world.broadcast(n3, DoubleBuf.buffer(dArray));
            } else {
                world.broadcast(n3, row_i_buf);
                dArray = row_i;
            }
            for (int j = n; j <= n2; ++j) {
                object = d[j];
                for (int k = 0; k < FloydClu.n; ++k) {
                    object[k] = Math.min((double)object[k], (double)(object[i] + dArray[k]));
                }
            }
        }
        long l3 = System.currentTimeMillis();
        DoubleMatrixFile doubleMatrixFile2 = new DoubleMatrixFile(FloydClu.n, FloydClu.n, d);
        object = doubleMatrixFile2.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(file2, rank))));
        ((DoubleMatrixFile.Writer)object).writeRowSlice(range);
        ((DoubleMatrixFile.Writer)object).close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.network.FloydClu <infile> <outfile>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

