## ----installation, eval=FALSE-------------------------------------------------
# if (!require("BiocManager")) {
#     install.packages("BiocManager")
# }
# BiocManager::install('XAItest')

## ----load libs, message=F-----------------------------------------------------
# Load the libraries
library(XAItest)
library(ggplot2)
library(ggforce)
library(gridExtra)
library(SummarizedExperiment)

## -----------------------------------------------------------------------------
data(airway, package="airway")
se <- airway

## ----first XAI.test, warning=FALSE--------------------------------------------
results <- XAI.test(se[1:100,], y = "dex", verbose = TRUE, simData = TRUE)

## -----------------------------------------------------------------------------
results

## ----load classif simu data---------------------------------------------------
se_path <- system.file("extdata", "seClassif.rds", package="XAItest")
dataset_classif <- readRDS(se_path)

data_matrix <- assay(dataset_classif, "counts")
data_matrix <- t(data_matrix)
metadata <- as.data.frame(colData(dataset_classif))
df_simu_classif <- as.data.frame(cbind(data_matrix, y = metadata[['y']]))
for (col in names(df_simu_classif)) {
    if (col != 'y') {
        df_simu_classif[[col]] <- as.numeric(df_simu_classif[[col]])
    }
}

## ----load dataframe ex classif simu data--------------------------------------
df_path <- system.file("extdata", "dfClassif.txt", package="XAItest")
dataset_classif_df <- read.table(df_path)
df_simu_classif_df <- dataset_classif

## ----fig.width=12, fig.height=5-----------------------------------------------
p1 <- ggplot(df_simu_classif, aes(x=norm_noise01, y=norm_noise02,
            color=y)) +
    geom_point() +
    ggtitle("Noise features\nnorm_noise01 vs norm_noise02") +
    theme_bw()
p2 <- ggplot(df_simu_classif, aes(x=diff_distrib01, y=diff_distrib02,
            color=y)) +
    geom_point() +
    ggtitle("Normal distributions\ndiff_distrib01 vs diff_distrib02") +
    theme_bw()
p3 <- ggplot(df_simu_classif, aes(x=norm_noise03, y=biDistrib, color=y)) +
    geom_point() +
    ggtitle("Normal bidistribution\nbidistrib01 vs norm_noise03") +
    theme_bw()
grid.arrange(p1, p2, p3, ncol = 3, nrow = 1)

## ----XAI.test 1 , warning=FALSE-----------------------------------------------
set.seed(123)
objXAI <- XAI.test(dataset_classif, "y", simData = TRUE, simPvalTarget = 0.01)

## -----------------------------------------------------------------------------
head(getMetricsTable(objXAI))

## ----mapPvalImportance1-------------------------------------------------------
mpi <- mapPvalImportance(objXAI)
mpi$df

## ----mapPvalImportance5, eval=FALSE-------------------------------------------
# mpi$dt

## ----xai2, warning=FALSE------------------------------------------------------
set.seed(123)
objXAI <- XAI.test(df_simu_classif[,setdiff(colnames(df_simu_classif),
                                    c("diff_distrib01", "diff_distrib02"))],
                  simData=TRUE)
head(getMetricsTable(objXAI))

## ----fig.width=10, fig.height=10----------------------------------------------
p1 <- plotModel(objXAI, "lm_pval", "biDistrib", "simFeat")
p2 <- plotModel(objXAI, "RF_feat_imp", "biDistrib", "simFeat")
p3 <- plotModel(objXAI, "SHAP_feat_imp", "biDistrib", "simFeat")
p4 <- plotModel(objXAI, "LIME_feat_imp", "biDistrib", "simFeat")
grid.arrange(p1, p2, p3, p4, ncol = 2, nrow = 2)

## ----mapPvalImportance2-------------------------------------------------------
mpi <- mapPvalImportance(objXAI)
head(mpi$df)

## ----mapPvalImportance15, eval=FALSE------------------------------------------
# mpi$dt

## -----------------------------------------------------------------------------
transfo_parab <- function(xs){
    x1 <- min(xs)
    x2 <- max(xs)
    h <- (x1 + x2) / 2
    k <- max(xs)/2
    a <- k / ((h - x1) * (h - x2))
    
    y <- a * (xs - x1) * (xs - x2)
    
    return (y)
}


## ----load regress simu data---------------------------------------------------
se_path <- system.file("extdata", "seRegress.rds", package="XAItest")
dataset_regress <- readRDS(se_path)

data_matrix <- assay(dataset_regress, "counts")
data_matrix <- t(data_matrix)
metadata <- as.data.frame(colData(dataset_regress))
df_simu_regr <- as.data.frame(cbind(data_matrix, y = metadata[['y']]))
for (col in names(df_simu_regr)) {
    if (col != 'y') {
        df_simu_regr[[col]] <- as.numeric(df_simu_regr[[col]])
    }
}

## ----load dataframe regress simu data-----------------------------------------
df_path <- system.file("extdata", "dfRegress.txt", package="XAItest")
dataset_regress_df <- read.table(df_path)
df_simu_regr_df <- dataset_regress

## -----------------------------------------------------------------------------
ggplot(df_simu_regr, aes(x=norm_noise2, y=y)) + geom_point() + theme_bw()

## ----xai3, warning=FALSE------------------------------------------------------
set.seed(123)
regr_results <- XAI.test(dataset_regress, "y",
                            simData=TRUE, simPvalTarget = 0.01)
getMetricsTable(regr_results)

## ----mapPvalImportance3-------------------------------------------------------
mpi <- mapPvalImportance(regr_results, refPvalColumn = "cor_adjPval", refPval = 0.01)
head(mpi$df)

## ----mapPvalImportance25, eval=FALSE------------------------------------------
# mpi$dt

## -----------------------------------------------------------------------------
regr_results@args$modelType

## ----fig.width=10, fig.height=5-----------------------------------------------
p1 <- plotModel(regr_results, "lm_pval", "norm_noise2")
p2 <- plotModel(regr_results, "SHAP_feat_imp", "norm_noise2")
grid.arrange(p1, p2, ncol = 2, nrow = 1)

## -----------------------------------------------------------------------------
modelsOverview(regr_results)

## -----------------------------------------------------------------------------
sessionInfo()

