/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.igsp.gkde.format;

import edu.duke.igsp.gkde.KDEChromosome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class BedReader {
    public static KDEChromosome[] read(File[] files) throws IOException {
        String[] chrnames;
        HashMap chrMap = new HashMap();
        String currentChr = null;
        ArrayList currentCuts = null;
        boolean lengthSet = false;
        int sequenceLength = 0;
        for (int i = 0; i < files.length; ++i) {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(files[i]));
            while ((line = br.readLine()) != null) {
                String[] arr = line.split("\t");
                if (arr.length < 6) {
                    BedReader.badFile(files[i]);
                }
                if (arr[0] != currentChr) {
                    if (!chrMap.containsKey(arr[0])) {
                        chrMap.put(arr[0], new ArrayList());
                    }
                    currentChr = arr[0];
                    currentCuts = (ArrayList)chrMap.get(arr[0]);
                }
                KDEChromosome.Sequence seq = new KDEChromosome.Sequence();
                try {
                    long s = Long.parseLong(arr[1]);
                    long e = Long.parseLong(arr[2]);
                    long diff = e - s;
                    if (!lengthSet) {
                        sequenceLength = (int)diff;
                        lengthSet = true;
                    }
                    if (Math.abs(diff) > 1L) {
                        seq = arr[5].equals("+") ? new KDEChromosome.Sequence(s, arr[5].equals("+")) : new KDEChromosome.Sequence(e, arr[5].equals("+"));
                        currentCuts.add(seq);
                        continue;
                    }
                    seq = new KDEChromosome.Sequence(s, arr[5].equals("+"));
                    currentCuts.add(seq);
                }
                catch (NumberFormatException e) {
                    BedReader.badFile(files[i]);
                }
            }
        }
        currentCuts = null;
        KDEChromosome[] chrs = new KDEChromosome[chrMap.size()];
        int i = 0;
        for (String chr : chrnames = chrMap.keySet().toArray(new String[0])) {
            currentCuts = (ArrayList)chrMap.remove(chr);
            Object[] cuts = new KDEChromosome.Sequence[currentCuts.size()];
            for (int j = 0; j < cuts.length; ++j) {
                cuts[j] = (KDEChromosome.Sequence)currentCuts.get(j);
            }
            Arrays.sort(cuts);
            chrs[i++] = new KDEChromosome(chr, (KDEChromosome.Sequence[])cuts, sequenceLength);
        }
        return chrs;
    }

    private static void badFile(File f) throws IOException {
        throw new IOException("Bad '.bed' format for file " + f.getAbsolutePath());
    }
}

