/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.function;

import org.jfree.pdf.function.Function;
import org.jfree.pdf.function.FunctionType;
import org.jfree.pdf.util.PDFUtils;

public final class ExponentialInterpolationFunction
extends Function {
    double n;
    float[] c0;
    float[] c1;

    public ExponentialInterpolationFunction(int number, float[] c0, float[] c1) {
        super(number, FunctionType.EXPONENTIAL_INTERPOLATION);
        this.dictionary.put("/N", "1");
        this.n = 1.0;
        this.setC0(c0);
        this.setC1(c1);
    }

    public double getN() {
        return this.n;
    }

    public void setN(double n) {
        this.n = n;
        this.dictionary.put("/N", String.valueOf(n));
    }

    public float[] getC0() {
        return (float[])this.c0.clone();
    }

    public void setC0(float[] c0) {
        this.c0 = (float[])c0.clone();
        this.dictionary.put("/C0", PDFUtils.toPDFArray(c0));
    }

    public float[] getC1() {
        return (float[])this.c1.clone();
    }

    public void setC1(float[] c1) {
        this.c1 = (float[])c1.clone();
        this.dictionary.put("/C1", PDFUtils.toPDFArray(c1));
    }
}

